<?php

namespace Bitcream\Corradi\Custom\console\migrations;

use yii\db\Migration;

/**
 * Handles the creation of table `{{%customer_supplier}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%payment_condition}}`
 * - `{{%customer}}`
 * - `{{%supplier}}`
 */
class M221012125438CreateJunctionTableForCustomerAndSupplierTables extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%customer_supplier}}', [
            'customer_id' => $this->integer(),
            'supplier_id' => $this->integer(),
            'payment_condition_id' => $this->integer()->null(),
            'PRIMARY KEY(customer_id, supplier_id)',
        ]);

        // creates index for column `payment_condition_id`
        $this->createIndex(
            '{{%idx-customer_supplier-payment_condition_id}}',
            '{{%customer_supplier}}',
            'payment_condition_id'
        );

        // add foreign key for table `{{%payment_condition}}`
        $this->addForeignKey(
            '{{%fk-customer_supplier-payment_condition_id}}',
            '{{%customer_supplier}}',
            'payment_condition_id',
            '{{%payment_condition}}',
            'id',
            'CASCADE'
        );

        // creates index for column `customer_id`
        $this->createIndex(
            '{{%idx-customer_supplier-customer_id}}',
            '{{%customer_supplier}}',
            'customer_id'
        );

        // add foreign key for table `{{%customer}}`
        $this->addForeignKey(
            '{{%fk-customer_supplier-customer_id}}',
            '{{%customer_supplier}}',
            'customer_id',
            '{{%customer}}',
            'id',
            'CASCADE'
        );

        // creates index for column `supplier_id`
        $this->createIndex(
            '{{%idx-customer_supplier-supplier_id}}',
            '{{%customer_supplier}}',
            'supplier_id'
        );

        // add foreign key for table `{{%supplier}}`
        $this->addForeignKey(
            '{{%fk-customer_supplier-supplier_id}}',
            '{{%customer_supplier}}',
            'supplier_id',
            '{{%supplier}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%payment_condition}}`
        $this->dropForeignKey(
            '{{%fk-customer_supplier-payment_condition_id}}',
            '{{%customer_supplier}}'
        );

        // drops index for column `payment_condition_id`
        $this->dropIndex(
            '{{%idx-customer_supplier-payment_condition_id}}',
            '{{%customer_supplier}}'
        );

        // drops foreign key for table `{{%customer}}`
        $this->dropForeignKey(
            '{{%fk-customer_supplier-customer_id}}',
            '{{%customer_supplier}}'
        );

        // drops index for column `customer_id`
        $this->dropIndex(
            '{{%idx-customer_supplier-customer_id}}',
            '{{%customer_supplier}}'
        );

        // drops foreign key for table `{{%supplier}}`
        $this->dropForeignKey(
            '{{%fk-customer_supplier-supplier_id}}',
            '{{%customer_supplier}}'
        );

        // drops index for column `supplier_id`
        $this->dropIndex(
            '{{%idx-customer_supplier-supplier_id}}',
            '{{%customer_supplier}}'
        );

        $this->dropTable('{{%customer_supplier}}');
    }
}
