<?php

namespace Bitcream\Corradi\Custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Toolkit\Model\SoftDeleteBehavior;
use Emberware\Evidia\Application\CreateUpdateStatus\StatusBehaviors;
use Emberware\Evidia\Application\CreateUpdateStatus\CreateUpdateBehaviors;
use bitcream\pim\custom\common\models\ProductModel;
/**
 * This is the model common class for table "supplier".
 */
class Supplier extends base\Supplier
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            // 'softDeleteBehavior' => [
            //     'class' => SoftDeleteBehavior::className(),
            //     'softDeleteAttributeValues' => [
            //         'status' => 0
            //     ],
            //     'replaceRegularDelete' => true // mutate native `delete()` method
            // ],
            // 'status' => [
            //     'class' => StatusBehaviors::className(),
            // ],
            // 'create-update' => [
            //     'class' => CreateUpdateBehaviors::className(),
            // ],
            'files' => [
                'class' => 'floor12\files\components\FileBehaviour',
                'attributes' => [
                    'certifications',
                    'logo',
                ],
            ],
       ]);
    }

    /**
    * {@inheritdoc}
    */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [
            ['certifications', 'file', 'extensions' => ['jpg', 'png', 'jpeg', 'gif'], 'maxFiles' => 5],
            ['logo', 'file', 'extensions' => ['jpg', 'png', 'jpeg', 'gif'], 'maxFiles' => 1],
        ]);
    }

    /**
    * {@inheritdoc}
    */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [
            'certifications' => Yii::t('app', 'Certifications'),
            'logo' => Yii::t('app', 'Logo'),
        ]);
    }

    /**
    * Rewrite function find for get only active element
    */
    public static function find(){
        return parent::find();
        // ->where(['status' => 30]);
    }

    public function fields()
    {
        return [
            'name' => 'business_name',
            'logo' => 'logoUrl',
            'description' => 'fullDescription',
            'mainColor',
            'certifications' => 'apiCertifications',
        ];
    }

    public function getFullDescription() //TODO prendere FullDescription fornitore dinamicamente dal fornitore
    {
        return '<p><strong>INDUSTRIE CELTEX S.p.a.</strong></p><p> SEDE OPERATIVA & LOGISTICA: Via dei Sandroni, 22 - 55011 Altopascio(LU)</p>';
    }

    public function getLogoUrl()
    {
        return Yii::$app->params['serverName'].$this->logo->href;
    }

    public function getMainColor() //TODO prendere main color dinamicamente dal fornitore
    {
        return '#96bd20';
    }

    public function getApiCertifications()
    {
		$certifications = [];
		foreach($this->certifications as $cert_key => $certification){
			$certifications[] = [
				'name' => 'cert_'.$cert_key,
				'icon' => Yii::$app->params['serverName'].$certification->href,
			];
		}
		return $certifications;
    }

    public function getPdfHeader()
    {
        $preHeader = [
            [
                'name' => Yii::t('app', 'Product Code'),
                "id" => "code",
                'keys' => ['product.codice'],
                'template' => 'code',
            ],
            [
                'name' => Yii::t('app', 'Title'),
                "id" => "title",
                'keys' => ['product.title','product.note'],
                'template' => 'description',
            ],
        ];
        switch ($this->id) { //TODO gestire gli header per altri fornitori
            case '9': //celtex //TODO prendere le configurazioni da db o config
                $customHeader = [
                    [
                        'name' => Yii::t('app', 'line'),
                        "id" => "line",
                        // 'keys' => ['product.line_id'], //linea_celtex
                        'template' => 'line',
                    ],
                    [
                        'name' => Yii::t('app', 'materia_prima'),
                        "id" => "materiaPrima",
                        'keys' => ['product.materia_prima'],
                        'template' => 'default',
                    ],
                    [
                        'name' => Yii::t('app', 'lavorazione'),
                        "id" => "lavorazione",
                        'keys' => ['product.lavorazione'],
                        'template' => 'default',
                    ],
                    [
                        'name' => Yii::t('app', 'lavorazione'),
                        "id" => "numeroVeli",
                        'keys' => ['product.colore'],
                        'template' => 'default',
                    ],
                    [
                        'name' => Yii::t('app', 'numero_veli'),
                        "id" => "numeroVeli",
                        'keys' => ['product.numero_veli'],
                        'template' => 'default',
                    ],
                    [
                        'name' => Yii::t('app', 'formato'),
                        "id" => "formato",
                        'keys' => ['product.formato'],
                        'template' => 'default',
                    ],
                    [
                        'name' => Yii::t('app', 'pz_per_confezione'),
                        "id" => "pzPerConfezione",
                        'keys' => ['product.pz_per_confezione'],
                        'template' => 'default',
                    ],
                    [
                        'name' => Yii::t('app', 'confezioni_per_collo'),
                        "id" => "confezioniPerCollo",
                        'keys' => ['product.confezioni_per_collo'],
                        'template' => 'default',
                    ],
                    [
                        'name' => Yii::t('app', 'pz_per_collo'),
                        "id" => "confezioniPerCollo",
                        'keys' => ['product.pz_per_collo'],
                        'template' => 'default',
                    ],
                    [
                        'name' => Yii::t('app', 'colli_per_pallet'),
                        "id" => "colliPerPallet",
                        'keys' => ['product.colli_per_pallet'],
                        'template' => 'default',
                    ],
                    [
                        'name' => Yii::t('app', 'Gross price'),
                        "id" => "grossPrice",
                        'keys' => ['offerData.gross_price'],
                        'template' => 'price',
                    ],
                ];
                break;

            default:
                $customHeader = [];
                break;
        }
        $postHeader = [
            [
                'name' => Yii::t('app', 'Discount  1'),
                "id" => "discount1",
                'keys' => ['offerData.discount_1'],
                'template' => 'percentage',
            ],
            [
                'name' => Yii::t('app', 'Dscount  2'),
                "id" => "discount2",
                'keys' => ['offerData.discount_2'],
                'template' => 'percentage',
            ],
            [
                'name' => Yii::t('app', 'Discount  3'),
                "id" => "discount3",
                'keys' => ['offerData.discount_3'],
                'template' => 'percentage',
            ],
            [
                'name' => Yii::t('app', 'Discount  4'),
                "id" => "discount4",
                'keys' => ['offerData.discount_4'],
                'template' => 'percentage',
            ],
            // [
            //     'name' => 'Sconto 5',
            //     'keys' => ['offerData.discount_5'],
            //     'template' => 'percentage',
            // ],
            // [
            //     'name' => 'Sconto 6',
            //     'keys' => ['offerData.discount_6'],
            //     'template' => 'percentage',
            // ],
            [
                'name' => Yii::t('app', 'Net Price'),
                "id" => "netPrice",
                'keys' => ['offerData.net_price'],
                'template' => 'price',
            ],
            [
                'name' => Yii::t('app', 'Merchandise Discount'),
                "id" => "merchandiseDiscount",
                'keys' => ['offerData.merchandise_discount'],
                'template' => 'default',
            ],
            [
                'name' => Yii::t('app', 'Net price after merchandise discount'),
                "id" => "netPriceAfterMerchandiseDiscount",
                "dependsFrom" => "merchandiseDiscount",
                'keys' => ['offerData.netPriceAfterMerchandiseDiscount'],
                'template' => 'price',
            ],
            // [
            //     'name' => '€ collo',
            //     'keys' => ['discounts.sc-6'],
            //     'template' => 'percentage',
            // ],
        ];
        return array_merge($preHeader, $customHeader, $postHeader);
    }

    public function getCategoryProductModelSlug()
    {
        switch ($this->id) {
            case '9':   //celtex //TODO prendere dinamicamente dalla categoria
                return 'categoria_celtex';
                break;
            case '28':   //Bettari
                return 'categoria_bettari';
                break;
            case '26':   //bibo
                return 'categoria_bibo';
                break;
            case '22':   //Ceplast
                return 'categoria_ceplast';
                break;
            case '24':   //Mechanotools / Icont
                return 'categoria_icont';
                break;
            default:
                return false;
                break;
        }
    }

    public function getCategories()
    {
        return ProductModel::findOne(['slug' => $this->getCategoryProductModelSlug()])?->getProducts();
    }

    public function getLineProductModelSlug()
    {
        switch ($this->id) {
            case '9':   //celtex //TODO prendere linee dinamicamente
                return 'linea_celtex';
                break;
            default:
                return false;
                break;
        }
    }

    public function getDivisionProductModelSlug()
    {
        switch ($this->id) {
            case '9':   //celtex //TODO prendere divisioni dinamicamente dalla categoria
                return 'divisione_celtex';
                break;
            case '28':   //Bettari
                return 'divisione_bettari';
                break;
            case '26':   //bibo
                return 'divisione_bibo';
                break;
            case '22':   //Ceplast
                return 'divisione_ceplast';
                break;
            case '24':   //Mechanotools / Icont
                return 'divisione_icont';
                break;
            default:
                return false;
                break;
        }
    }

    public function getSaleConditions()
    {
        $saleConditions= [];
        if (!empty($this->minimum_value))
            $saleConditions[] = [
                'label' => $this->attributeLabels()['minimum_value'],
                'content' => $this->minimum_value,
            ];
        if (!empty($this->minimum_value))
            $saleConditions[] = [
                'label' => $this->attributeLabels()['free_port'],
                'content' => $this->free_port,
            ];
        if (!empty($this->minimum_value))
            $saleConditions[] = [
                'label' => $this->attributeLabels()['free_port_contribution'],
                'content' => $this->free_port_contribution,
            ];
        if (!empty($this->minimum_value))
            $saleConditions[] = [
                'label' => $this->attributeLabels()['delivery_time'],
                'content' => $this->delivery_time,
            ];

        return $saleConditions;
    }

}
