<?php

namespace Bitcream\Corradi\Custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%offer_products}}".
 *
 * @property int $id
 * @property int $offer_id
 * @property string $product_code
 * @property int|null $show_avalibility
 * @property float|null $discount_1
 * @property float|null $dscount_2
 * @property float|null $discount_3
 * @property float|null $discount_4
 * @property float|null $discount_5
 * @property float|null $net_price
 * @property float|null $merchandise_discount
 * @property string|null $notes
 *
 * @property Offer $offer
 */
class OfferProducts extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%offer_products}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['offer_id', 'product_code'], 'required'],
            [['offer_id', 'show_avalibility'], 'integer'],
            [['discount_1', 'dscount_2', 'discount_3', 'discount_4', 'discount_5', 'net_price', 'merchandise_discount'], 'number'],
            [['product_code'], 'string', 'max' => 20],
            [['notes'], 'string', 'max' => 255],
            [['offer_id'], 'exist', 'skipOnError' => true, 'targetClass' => Offer::className(), 'targetAttribute' => ['offer_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'offer_id' => Yii::t('app', 'Offer ID'),
            'product_code' => Yii::t('app', 'Product Code'),
            'show_avalibility' => Yii::t('app', 'Show Avalibility'),
            'discount_1' => Yii::t('app', 'Discount  1'),
            'dscount_2' => Yii::t('app', 'Dscount  2'),
            'discount_3' => Yii::t('app', 'Discount  3'),
            'discount_4' => Yii::t('app', 'Discount  4'),
            'discount_5' => Yii::t('app', 'Discount  5'),
            'net_price' => Yii::t('app', 'Net Price'),
            'merchandise_discount' => Yii::t('app', 'Merchandise Discount'),
            'notes' => Yii::t('app', 'Notes'),
        ];
    }

    /**
     * Gets query for [[Offer]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOffer()
    {
        return $this->hasOne(Offer::className(), ['id' => 'offer_id']);
    }
}
