<?php

namespace Bitcream\Corradi\Custom\console\migrations;

use yii\db\Migration;

/**
 * Handles the creation of table `{{%offer_category}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%offer}}`
 * - `{{%product}}`
 */
class M221115150352CreateOfferCategoryTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%offer_category}}', [
            'id' => $this->primaryKey(),
            'offer_id' => $this->integer()->notNull(),
            'category_id' => $this->integer()->notNull(),
        ]);

        // creates index for column `offer_id`
        $this->createIndex(
            '{{%idx-offer_category-offer_id}}',
            '{{%offer_category}}',
            'offer_id'
        );

        // add foreign key for table `{{%offer}}`
        $this->addForeignKey(
            '{{%fk-offer_category-offer_id}}',
            '{{%offer_category}}',
            'offer_id',
            '{{%offer}}',
            'id',
            'CASCADE'
        );

        // creates index for column `category_id`
        $this->createIndex(
            '{{%idx-offer_category-category_id}}',
            '{{%offer_category}}',
            'category_id'
        );

        // add foreign key for table `{{%product}}`
        $this->addForeignKey(
            '{{%fk-offer_category-category_id}}',
            '{{%offer_category}}',
            'category_id',
            '{{%product}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%offer}}`
        $this->dropForeignKey(
            '{{%fk-offer_category-offer_id}}',
            '{{%offer_category}}'
        );

        // drops index for column `offer_id`
        $this->dropIndex(
            '{{%idx-offer_category-offer_id}}',
            '{{%offer_category}}'
        );

        // drops foreign key for table `{{%product}}`
        $this->dropForeignKey(
            '{{%fk-offer_category-category_id}}',
            '{{%offer_category}}'
        );

        // drops index for column `category_id`
        $this->dropIndex(
            '{{%idx-offer_category-category_id}}',
            '{{%offer_category}}'
        );

        $this->dropTable('{{%offer_category}}');
    }
}
