<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Field\Date\Date;

/* @var $this yii\web\View */
/* @var $model Bitcream\Corradi\Custom\common\models\Offer */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="offer-form">

    <?php $form = ActiveForm::begin(); ?>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
              <?= $form->field($model, 'delivery_terms_notes')->textarea(['rows' => 6]) ?>
           </div>
        </div>

        <div class='row'>
            <div class='col-md-6 col-xs-12'>
                <?= $form->field($model, 'tail_lift_notes')->textarea(['rows' => 6]) ?>

            </div>
        </div>

        <div class='row'>
            <div class='col-md-6 col-xs-12'>
                <?= $form->field($model, 'payment_condition_id')->widget(Select2::class, [
                'name' => 'payment_condition_id',
                'class' => 'form-group payment_condition_id form-control',
                'value' => ArrayHelper::map($paymentConditions, 'id', function ($paymentCondition) {
                    return $paymentCondition['name'];
                }),
                'id' => 'payment_condition_id',
                'data' => ArrayHelper::map($paymentConditions, 'id', function ($paymentCondition) {
                    return $paymentCondition['name'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select payment conditions')]
            ])->label(Yii::t('app', 'Payment conditions'));?>


            </div>
        </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'payment_notes')->textarea(['rows' => 6]) ?>

           </div>
        </div>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
