<?php

namespace Bitcream\Corradi\Custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%payment_condition}}".
 *
 * @property int $id
 * @property string $name
 * @property string|null $discount
 * @property int|null $is_bank_payment
 *
 * @property Offer[] $offers
 */
class PaymentCondition extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%payment_condition}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name'], 'required'],
            [['is_bank_payment'], 'integer'],
            [['name'], 'string', 'max' => 100],
            [['discount'], 'string', 'max' => 12],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'name' => Yii::t('app', 'Name'),
            'discount' => Yii::t('app', 'Discount'),
            'is_bank_payment' => Yii::t('app', 'Is Bank Payment'),
        ];
    }

    /**
     * Gets query for [[Offers]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOffers()
    {
        return $this->hasMany(Offer::className(), ['payment_condition_id' => 'id']);
    }
}
