<?php

namespace Bitcream\Corradi\Custom\console\migrations;

use yii\db\Migration;

/**
 * Handles the creation of table `{{%price_list}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%supplier}}`
 * - `{{%customer}}`
 */
class M220923023045CreatePriceListTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%price_list}}', [
            'id' => $this->primaryKey(),
            'name' => $this->string(20),
            'supplier_id' => $this->integer(),
            'customer_id' => $this->integer()->null(),
        ]);

        // creates index for column `supplier_id`
        $this->createIndex(
            '{{%idx-price_list-supplier_id}}',
            '{{%price_list}}',
            'supplier_id'
        );

        // add foreign key for table `{{%supplier}}`
        $this->addForeignKey(
            '{{%fk-price_list-supplier_id}}',
            '{{%price_list}}',
            'supplier_id',
            '{{%supplier}}',
            'id',
            'CASCADE'
        );

        // creates index for column `customer_id`
        $this->createIndex(
            '{{%idx-price_list-customer_id}}',
            '{{%price_list}}',
            'customer_id'
        );

        // add foreign key for table `{{%customer}}`
        $this->addForeignKey(
            '{{%fk-price_list-customer_id}}',
            '{{%price_list}}',
            'customer_id',
            '{{%customer}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%supplier}}`
        $this->dropForeignKey(
            '{{%fk-price_list-supplier_id}}',
            '{{%price_list}}'
        );

        // drops index for column `supplier_id`
        $this->dropIndex(
            '{{%idx-price_list-supplier_id}}',
            '{{%price_list}}'
        );

        // drops foreign key for table `{{%customer}}`
        $this->dropForeignKey(
            '{{%fk-price_list-customer_id}}',
            '{{%price_list}}'
        );

        // drops index for column `customer_id`
        $this->dropIndex(
            '{{%idx-price_list-customer_id}}',
            '{{%price_list}}'
        );

        $this->dropTable('{{%price_list}}');
    }
}
