<?php

namespace Bitcream\Corradi\Custom\console\migrations;

use yii\db\Migration;

/**
 * Handles dropping columns from table `{{%offer}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%return_condition}}`
 */
class M221012094341DropReturnConditionIdNameColumnFromOfferTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // drops foreign key for table `{{%return_condition}}`
        $this->dropForeignKey(
            '{{%fk-offer-return_condition_id}}',
            '{{%offer}}'
        );

        // drops index for column `return_condition_id`
        $this->dropIndex(
            '{{%idx-offer-return_condition_id}}',
            '{{%offer}}'
        );

        $this->dropColumn('{{%offer}}', 'return_condition_id');
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->addColumn('{{%offer}}', 'return_condition_id', $this->integer()->null());

        // creates index for column `return_condition_id`
        $this->createIndex(
            '{{%idx-offer-return_condition_id}}',
            '{{%offer}}',
            'return_condition_id'
        );

        // add foreign key for table `{{%return_condition}}`
        $this->addForeignKey(
            '{{%fk-offer-return_condition_id}}',
            '{{%offer}}',
            'return_condition_id',
            '{{%return_condition}}',
            'id',
            'CASCADE'
        );
    }
}
