<?php

namespace Bitcream\Corradi\Custom\console\migrations;

use yii\db\Migration;

/**
 * Handles dropping columns from table `{{%price_list_product_price}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%price_list}}`
 */
class M221013160722DropPriceListIdColumnFromPriceListProductPriceTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // drops foreign key for table `{{%price_list}}`
        // $this->dropForeignKey(
        //     '{{%fk-price_list_product_price-price_list_id}}',
        //     '{{%price_list_product_price}}'
        // );

        // drops index for column `price_list_id`
        $this->dropIndex(
            '{{%idx-price_list_product_price-price_list_id}}',
            '{{%price_list_product_price}}'
        );

        $this->dropColumn('{{%price_list_product_price}}', 'price_list_id');
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->addColumn('{{%price_list_product_price}}', 'price_list_id', $this->integer()->notNull());

        // creates index for column `price_list_id`
        $this->createIndex(
            '{{%idx-price_list_product_price-price_list_id}}',
            '{{%price_list_product_price}}',
            'price_list_id'
        );

        // add foreign key for table `{{%price_list}}`
        $this->addForeignKey(
            '{{%fk-price_list_product_price-price_list_id}}',
            '{{%price_list_product_price}}',
            'price_list_id',
            '{{%price_list}}',
            'id',
            'CASCADE'
        );
    }
}
