<?php

namespace Bitcream\Corradi\Custom\backend\controllers;

use Bitcream\Corradi\Custom\backend\models\OfferProductsSearch;
use Yii;
use Bitcream\Corradi\Custom\common\models\Offer;
use Bitcream\Corradi\Custom\backend\models\OfferSearch;
use Bitcream\Corradi\Custom\common\models\Agent;
use Bitcream\Corradi\Custom\common\models\Customer;
use Bitcream\Corradi\Custom\common\models\CustomerSupplier;
use Bitcream\Corradi\Custom\common\models\OfferProducts;
use Bitcream\Corradi\Custom\common\models\PaymentCondition;
use Bitcream\Corradi\Custom\common\models\PriceList;
use Bitcream\Corradi\Custom\common\models\ReturnCondition;
use Bitcream\Corradi\Custom\common\models\Supplier;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;

/**
 * OfferController implements the CRUD actions for Offer model.
 */
class OfferController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Offer models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new OfferSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Offer model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Offer model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Offer();

        return $this->updateHeader($model, 'step-price-list');
    }

 /**
     * Updates an existing Offer model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdateHeader($id)
    {
        $model = $this->findModel($id);
        return $this->updateHeader($model, 'view');
    }


    /**
     * Updates an existing Offer model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index']);
        }

        return $this->render('update', [
            'model' => $model,
            'updatePart'=> 'all',
            'suppliers' => Supplier::find()->all(),
            'customers' => Customer::find()->all(),
            'paymentConditions' => PaymentCondition::find()->all(),
            'returnConditions' => ReturnCondition::find()->all(),
            'agents' => Agent::find()->all(),
        ]);
    }

    /**
     * Updates an existing Offer model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param Offer $id
     * @param string $redirect
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function updateHeader($model, string $redirect)
    {

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            if(empty(Yii::$app->request->post('Offer')['start_date'])){
                // echo json_encode(Yii::$app->request->post('Offer')['start_date']);
                $model->start_date = time();
                $model->save(false);
            }
            $model->pullFromCustomerSupplier(['payment_condition_id'=>'payment_condition_id']);
            return $this->redirect([$redirect, 'id'=>$model->id]);
        }

        return $this->render('update', [
            'model' => $model,
            'updatePart'=> 'header',
            'suppliers' => Supplier::find()->all(),
            'customers' => Customer::find()->all(),
            'agents' => Agent::find()->all(),
        ]);
    }


    /**
     * Updates an existing Offer model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @param string $redirect
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function updatePriceList($id, string $redirect)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            if(!empty(Yii::$app->request->post('Offer')['priceListsIds'])){
                $model->setPriceListsIds(Yii::$app->request->post('Offer')['priceListsIds']);
                $model->setCategoriesIds(Yii::$app->request->post('Offer')['categoriesIds']);
            }
            return $this->redirect([$redirect, 'id'=>$model->id]);
        }

        $searchProductsModel = new OfferProductsSearch();
        $dataProductsProvider = $searchProductsModel->search(Yii::$app->request->queryParams);

        return $this->render('update', [
            'model' => $model,
            'updatePart'=> 'priceList',
            'priceLists' => PriceList::findAll(['supplier_id'=>$model->supplier_id]),
            'searchProductsModel' => $searchProductsModel,
            'dataProductsProvider' => $dataProductsProvider,
        ]);
    }

 /**
     * Updates an existing Offer model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdatePriceList($id)
    {
        return $this->updatePriceList($id, 'add-products');
    }

    /**
     * Updates an existing Offer model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionStepPriceList($id)
    {
        return $this->updatePriceList($id, 'step-add-products');
    }



    /**
     * Updates an existing Offer model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function addProducts($id, string $redirec = 'view', string $backRedirec = 'update-price-list')
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            $model->setProductsCodes(Yii::$app->request->post('Offer')['productsCodes']);
            return $this->redirect([$redirec, 'id'=>$model->id]);
        }

        if(!$model->checkPriceLists()){
            return $this->redirect([$backRedirec, 'id'=>$model->id]);
        }
        return $this->render('update', [
            'model' => $model,
            'updatePart'=> 'add-products',
            'redirect' => $redirec,
            // 'products' => PriceList::findAll(['supplier_id'=>$model->supplier_id]),
        ]);
    }

    /**
     * Updates an existing Offer model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionAddProducts($id)
    {
        return $this->addProducts($id, 'update-products');
    }

    /**
     * Updates an existing Offer model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionStepAddProducts($id)
    {
        return $this->addProducts($id, 'step-products');
    }


    /**
     * Updates an existing Offer model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @param string $redirect
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function updateProducts($id, string $redirect)
    {
        $model = $this->findModel($id);

        if ($this->request->isPost) {
            if (OfferProducts::loadMultiple($model->offerProducts, $this->request->post(),'OfferProducts') && OfferProducts::validateMultiple($model->offerProducts)) {
                foreach ($model->offerProducts as $offerProduct) {
                    $offerProduct->save(false);
                }
                return $this->redirect([$redirect, 'id'=>$model->id]);
            }
        }

        return $this->render('update', [
            'model' => $model,
            'updatePart'=> 'products',
        ]);
    }

    /**
     * Updates an existing Offer model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdateProducts($id)
    {
        return $this->updateProducts($id, 'update-products');
    }

    /**
     * Updates an existing Offer model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionStepProducts($id)
    {
        return $this->updateProducts($id, 'update-footer');
    }

    /**
     * Updates an existing Offer model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdateFooter($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            $model->pushToCustomerSupplier(['payment_condition_id'=>'payment_condition_id']);
            return $this->redirect(['view', 'id'=>$model->id]);
        }

        return $this->render('update', [
            'model' => $model,
            'updatePart'=> 'footer',
            'paymentConditions' => PaymentCondition::find()->all(),
            'returnConditions' => ReturnCondition::find()->all(),
        ]);
    }

    /**
     * Deletes an existing Offer model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Offer model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Offer the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Offer::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }
}
