<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model Bitcream\Corradi\Custom\common\models\PriceListProductPrice */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="price-list-product-price-form">

    <?php $form = ActiveForm::begin(); ?>
        <div class='row'>
           <div class='col-md-6 col-xs-12'>
           <?= DetailView::widget([
            'model' => $model,
            'attributes' => [
                [
                    'label' => Yii::t('app', 'Price List'),
                    'value' => function($data){
                        return $data->priceList->name;
                    },
                ],
                'product_code',
            ],
            ]) ?>
            </div>
        </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'price')->textInput() ?>
           </div>
        </div>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
