<?php

namespace Bitcream\Corradi\Custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Toolkit\Model\SoftDeleteBehavior;
use Emberware\Evidia\Application\CreateUpdateStatus\StatusBehaviors;
use Emberware\Evidia\Application\CreateUpdateStatus\CreateUpdateBehaviors;
use yii\data\ActiveDataProvider;
use bitcream\pim\custom\common\models\ProductModel;
use yii\behaviors\TimestampBehavior;
use yii\helpers\Url;

/**
 * This is the model common class for table "offer".
 */
class Offer extends base\Offer
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            // 'softDeleteBehavior' => [
            //     'class' => SoftDeleteBehavior::className(),
            //     'softDeleteAttributeValues' => [
            //         'status' => 0
            //     ],
            //     'replaceRegularDelete' => true // mutate native `delete()` method
            // ],
            // 'status' => [
            //     'class' => StatusBehaviors::className(),
            // ],
            // 'create-update' => [
            //     'class' => CreateUpdateBehaviors::className(),
            // ],
            [
                'class' => TimestampBehavior::class,
            ],
       ]);
    }

    /**
    * {@inheritdoc}
    */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [
            [['customer_id', 'supplier_id'], 'required'],
        ]);
    }

    /**
    * {@inheritdoc}
    */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [
        ]);
    }

    /**
    * Rewrite function find for get only active element
    */
    public static function find(){
        return parent::find();
        // ->where(['status' => 30]);
    }

    /**
     * Gets query for [[Agent]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getAgent()
    {
        return $this->hasOne(Agent::className(), ['id' => 'agent_id']);
    }

    /**
     * Gets query for [[Customer]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCustomer()
    {
        return $this->hasOne(Customer::className(), ['id' => 'customer_id']);
    }

    /**
     * Gets query for [[OfferPriceLists]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOfferPriceLists()
    {
        return $this->hasMany(OfferPriceList::className(), ['offer_id' => 'id']);
    }

    /**
     * Gets query for [[OfferProducts]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOfferProducts()
    {
        return $this->hasMany(OfferProducts::className(), ['offer_id' => 'id'])->indexBy('id');
    }

    /**
     * Gets query for [[PaymentCondition]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPaymentCondition()
    {
        return $this->hasOne(PaymentCondition::className(), ['id' => 'payment_condition_id']);
    }

    /**
     * Gets query for [[PriceLists]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPriceLists()
    {
        return $this->hasMany(PriceList::className(), ['id' => 'price_list_id'])->via('offerPriceLists');
    }

    /**
     * Gets query for [[Categories]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCategories()
    {
        return $this->hasMany(CProduct::className(), ['id' => 'category_id'])->via('offerCategories');
    }

    /**
     * Gets query for [[Supplier]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getSupplier()
    {
        return $this->hasOne(Supplier::className(), ['id' => 'supplier_id']);
    }

    public function getSelectedCategories()
    {
        $selected = $this->categories?:$this->availableCategories;
        return $selected;
    }

    public function getAvailableCategories()
    {
        return $this->supplier?->categories;
    }

    public function fields(){
        return [
            'id',
        ];
    }

    public function extraFields(){
        return [
            //offer product selection
            'selectedProducts',
            'filters',
            'header',
            'availableProducts',
            //pdf offer
            'info',
            'content' => 'pdfContent',
            'businessOwner' => 'pdfBusinessOwner',
        ];
    }

    /**
     * Get Supplier Name
     */
    public function getSupplierName(){
        return $this->supplier->name;
    }
    /**
     * Get Customer Name
     */
    public function getCustomerName(){
        return $this->customer->name;
    }

    public function getSelectedProducts(){ //TODO probabilmente quessta funzione è uguale a $this ->getProductsIds, ma sembra che questa sia più performante
        $productsIds = [];
        foreach ($this->offerProducts as $offerProduct) {
            $productsIds[] = $offerProduct->product->id;
        }
        return $productsIds;
    }

    public function getFilters(){

        $returnCategories = [];
        if($this->getCategories()->exists()){
            $categories = $this->categories;
        }
        else{
            $categories = $this->supplier->categories;
        }
        foreach($categories as $category){
            $returnCategories[] = [
                'id' => $category->id,
                'slug' => 'slug_'.$category->id,
                'name' => $category->title,
            ];
        }
        return [
            [
                "name" => "Categorie",
                "key" => "category_id",
                "items" => $returnCategories,
            ],
            [
                "name" => Yii::t('app', 'Linee'),
                "key" => "line_id",
                "items" => $this->getPdfContentLines(),
            ],
        ];
    }

    public function getHeader(){

        $defaultHeaders = [
            [
                "name" => "codice",
                "keys" => ["codice"],
                "template" => "default" // default || description || price || percentage
            ],
            [
                "name" => "alert",
                "keys" => ["disponibilita_prodotto"],
                "template" => "alert",
            ],
            [
                "name" => "nome",
                "keys" => [
                    "title",
                    "description",
                ],
                "template" => "description",
            ],
        ];

        $supplier_id = 9; //TODO prendere il supplier dal prodotto
        switch ($supplier_id) {
            case '9':
                $customHeaders = [
                    [
                        "name" => Yii::t('app', 'line'),
                        "keys" => [
                            "line",
                        ],
                        "template" => "linea",
                    ],
                    [
                        "name" => Yii::t('app', 'materia_prima'),
                        "keys" => [
                            "materia_prima",
                        ],
                    ],
                    [
                        "name" => Yii::t('app', 'lavorazione'),
                        "keys" => [
                            "lavorazione",
                        ],
                    ],
                    // [
                    //     "name" => Yii::t('app', 'colore'),
                    //     "keys" => [
                    //         "colore",
                    //     ],
                    // ],
                    [
                        "name" => Yii::t('app', 'numero_veli'),
                        "keys" => [
                            "numero_veli",
                        ],
                    ],
                    [
                        "name" => Yii::t('app', 'formato'),
                        "keys" => [
                            "formato",
                        ],
                    ],
                ];
                break;
            default:
                $customHeaders = [];
                break;
        }

        $attributesPimProducts = [];
        if (!empty($this->getOfferProducts()->one())) {
            if ($this->getOfferProducts()->one()->product->pz_per_confezione) {
                $attributesPimProducts[]= [
                        "name" => Yii::t('app', 'pz_per_confezione'),
                        "keys" => ["pz_per_confezione"],
                        "template" => "default",
                ];
            }
            if ($this->getOfferProducts()->one()->product->confezioni_per_collo) {
                $attributesPimProducts[]= [
                    "name" => Yii::t('app', 'confezioni_per_collo'),
                    "keys" => ["confezioni_per_collo"],
                    "template" => "default",
                ];
            }
            if ($this->getOfferProducts()->one()->product->colli_per_pallet) {
                $attributesPimProducts[]= [
                    "name" => Yii::t('app', 'colli_per_pallet'),
                    "keys" => ["colli_per_pallet"],
                    "template" => "default",
                ];
            }
            if ($this->getOfferProducts()->one()->product->colli_per_strato) {
                $attributesPimProducts[]= [
                    "name" => Yii::t('app', 'colli_per_strato'),
                    "keys" => ["colli_per_strato"],
                    "template" => "default",
                ];
            }
        }
        return array_merge($defaultHeaders,$customHeaders,$attributesPimProducts);
    }

    public function getAvailableProducts(){
        $availableProducts = [];
        $priceList = $this->getPriceLists()->one();
        $codes = $priceList->getPriceListProductPrice()
        ->select('product_code')
        // ->limit(100)    //TODO togliere quando prestazioni buone
        ->column();
        $availableProductsIds = CProduct::findIdByCode($codes);
        //working
        if(!($this->getCategories()->exists())){
            // $availableProducts = CProduct::findAll(["id" => $availableProductsIds]);
            $availableProducts = CProduct::find()->where(["id" => $availableProductsIds])->cache(7200)->all();
            return $availableProducts;
        }
        // $availableProducts = CProduct::findAll(["id" => $availableProductsIds]);
        $categoriesIds = $this->getCategories()->select('id')->column();
        // $availableProducts = CProduct::find()->where(["id" => $availableProductsIds])->cache(7200)->all();
        $availableProducts = CProduct::findCategoriesChildProducts($categoriesIds, $availableProductsIds);
        return $availableProducts;
    }

    public function getSalesConditions()
    {
        return array_merge($this->supplier->saleConditions,$this->getOfferSalesConditions());
    }

    public function getOfferSalesConditions()
    {
        $saleConditions= [];
        if (!empty($this->delivery_terms_notes))
            $saleConditions[] = [
                'label' => $this->attributeLabels()['delivery_terms_notes'],
                'content' => $this->delivery_terms_notes,
            ];
        if (!empty($this->tail_lift_notes))
            $saleConditions[] = [
                'label' => $this->attributeLabels()['tail_lift_notes'],
                'content' => $this->tail_lift_notes,
            ];
        if (!empty($this->paymentCondition))
            $saleConditions[] = [
                'label' => $this->attributeLabels()['payment_condition_id'],
                'content' => $this->paymentCondition->name,
            ];
        if (!empty($this->payment_notes))
            $saleConditions[] = [
                'label' => $this->attributeLabels()['payment_notes'],
                'content' => $this->payment_notes,
            ];

        return $saleConditions;
    }

    public function getInfo()
    {
        return[
            'title' => $this->pdfTitle,
            'number' => $this->id,
            'data' => $this->start_date,
            'salesAgent' => $this->agent?:"",
            'customer' => [
                'name' => $this->customer->business_name,
                'address' => $this->customer->fullAddress,
                'person' => $this->your_kind_attention,
            ],
            'supplier' => $this->supplier,
            'saleConditions' => $this->salesConditions,
        ];
    }

    //<YYYY.MM.GG>_<nome fornitore>_Listino_<nome listino>_riservato_<nome cliente>
    public function getPdfName()
    {
        return date("Y.m.d", intval($this->start_date))
            ."_".$this->supplier->business_name
            ."_Listino ".$this->priceLists[0]->name
            ."_riservato ".$this->customer->business_name;
    }

    //“Listino riservato” <Nome listino> <data ultima modifica>
    public function getPdfTitle()
    {
        return 'Listino riservato'
            .' '.$this->priceLists[0]->name
            .' _ Offerta aggiornata al '.date("d/m/Y", $this->updated_at);
    }

    public function getPdfContent()
    {
        return[
            'lines' => $this->getPdfContentLines(),
            'lineKey' => 'product.line_id',
            'header' => $this->supplier->pdfHeader,
            'categories' => $this->getPdfContentCategories(),
        ];
    }

    public function getPdfContentLines()
    {
        $lineProductModelSlug = $this->supplier->getLineProductModelSlug();
        if(!$lineProductModelSlug) return [];
        $lineProductModel = ProductModel::findOne(['slug' => $lineProductModelSlug]);
        $pdfContentLines = [];
        foreach ($lineProductModel->products as $product) {
            $line = CProduct::findOne($product->id);
            $pdfContentLines[] = [
                'id' => $line->id,
                'slug' => 'slug_'.$line->id,
                "name" => $line->title,
                "color" => $line->colore,
                "colorMode" => $line->colormodeText,
                // "colorMode" => "cell", //cell || row
                "description" => $line->description,
            ];
        }

        return $pdfContentLines;
    }

    public function getPdfContentHeader()
    {
        return $this->supplier->getPdfHeader();
    }

    public function getPdfContentCategories()
    {
        if(empty($this->productsIds)) return [];

        $contentCategories = [];
        foreach($this->selectedCategories as $category){
            $CategoryChildProducts = CProduct::findSelectedChildProducts($category->id, $this->productsIds);
            if(empty($CategoryChildProducts)) continue;
            $products = [];
            foreach ($CategoryChildProducts as $product) {
                $products[] = [
                    'product' => $product,
                    'offerData' => $this->getOfferProducts()->where(['product_code'=>$product->codice])->one(),
                ];
            }

            $contentCategories[] = [
                'name' => $category->title,
                'note' => $category->short_title,
                'description' => $category->description,
                'products' => $products,
            ];
            // break;
        }
        return $contentCategories;
    }

    // if(!empty($model->payment_condition_id)){
    //     CustomerSupplier::CreateOrUpdate(
    //         $model->customer_id,
    //         $model->supplier_id,
    //         ['payment_condition_id'=>$model->payment_condition_id]
    //     );
    // }

    public function getPdfBusinessOwner()
    {
        return [
            'logo' => Yii::$app->params['businessOwnerLogo'],
            'description' => Yii::$app->params['businessOwnerDescription'],
        ];
    }

    public function pullFromCustomerSupplier(Array $fields){
        // $fields = ['payment_condition_id'=>'payment_condition_id']
        $customerSupplier = $this->customerSupplier;
        if(!empty($customerSupplier)){
            foreach ($fields as $key => $value) {
                if(isset($customerSupplier->$key)){
                    $this->$value = $customerSupplier->$key;
                }
            }
            $this->save();
        }

    }

    public function pushToCustomerSupplier(Array $fields){
        // $fields = ['payment_condition_id'=>'payment_condition_id']
        // $customerSupplier = $this->customerSupplier;
        $params = [];

        foreach ($fields as $key => $value) {
            if(isset($this->$value) && !empty($this->$value)){
                $params[$key] = $this->$value;
            }
        }

        if(!empty($params)&& $this->customer_id && $this->supplier_id){
            CustomerSupplier::CreateOrUpdate($this->customer_id,$this->supplier_id,$params);
        }

    }

    public function getCustomerSupplier(){
        return CustomerSupplier::find()
        ->where([
            'customer_id' => $this->customer_id,
            'supplier_id' => $this->supplier_id,
        ])->one();
    }

    public function getPriceListsIds()
    {
        return $this->getPriceLists()->select('id')->column();
    }

    public function setPriceListsIds(array $priceListIds)
    {
        OfferPriceList::deleteAll(['offer_id'=>$this->id]);
        foreach ($priceListIds as $priceListId) {
            $this->link('priceLists', PriceList::findOne($priceListId));
        }
    }

    public function getCategoriesIds()
    {
        return $this->getCategories()->select('id')->column();
    }

    public function setCategoriesIds(string|array $categoriesIds)
    {
        OfferCategory::deleteAll(['offer_id'=>$this->id]);
        if(empty($categoriesIds)) return;
        foreach ($categoriesIds as $categoryId) {
            $this->link('categories', CProduct::findOne($categoryId));
        }
    }

    public function getProductsIds()
    {
        return array_map(function($id){return (int)$id;},CProduct::findIdByCode($this->getProductsCodes())) ;
    }

    public function getProductsCodes()
    {
        return $this->getOfferProducts()->select('product_code')->column();
    }

    public function setProductsCodes(string|array $productsCodes)
    {
        if(empty($productsCodes)) return;

        OfferProducts::deleteAll(['offer_id'=>$this->id]);
        $errors = [];
        foreach ($productsCodes as $productsCode) {
            $offerProduct = new OfferProducts();
            $offerProduct->offer_id = $this->id;
            $offerProduct->product_code = $productsCode;
            // $offerProduct->net_price = $this->priceLists[0]->getPrice($productsCode);
            if(!($offerProduct->save())){
                 $errors[] = [
                    'productsCode' => $productsCode,
                    'response_errors' => $offerProduct->errors,
            ];}
        }
        return (!empty($errors))?$errors:true;
    }
    public function setProductsIds(array $productIds)
    {
        if(empty($productIds)) return;

        $offerProducts = OfferProducts::findAll(['offer_id'=>$this->id]);
        $offerProductsProductsIds = [];
        foreach ($offerProducts as $offerProduct) {
            if(in_array($offerProduct->product->id,$productIds)){
                $offerProductsProductsIds[] = $offerProduct->product->id;
                continue;
            }
            $offerProduct->delete();
        }

        $errors = [];
        foreach ($productIds as $productId) {
            if(in_array($productId, $offerProductsProductsIds)) continue;
            $productsCode = CProduct::findOne($productId)?->codice;
            if(empty($productsCode)) continue;
            $offerProduct = new OfferProducts();
            $offerProduct->offer_id = $this->id;
            $offerProduct->product_code = $productsCode;
            // $offerProduct->net_price = $this->priceLists[0]->getPrice($productsCode);
            if(!($offerProduct->save())){
                 $errors[] = [
                    'productId' => $productId,
                    'productsCode' => $productsCode,
                    'response_errors' => $offerProduct->errors,
            ];}
        }
        return (!empty($errors))?$errors:true;
    }

    public function getProductsDataProvider(){
        return new ActiveDataProvider([
            'query' => $this->getOfferProducts(),
            'pagination' => false,
            'sort'=> ['defaultOrder' => ['product_code'=>SORT_ASC]],
        ]);
    }

    public function getPdfLink()
    {
        if(boolval(Yii::$app->params['GenerateOfferPdf'])){
            return Yii::$app->params['OfferPdfurl'].$this->id
                .'&fileName='.$this->pdfName;
        }
        return Yii::$app->params['OfferPdfurl'].$this->id
            .'?print=1';
    }

    public function checkPriceLists()
    {
        foreach ($this->priceLists as $priceList) {
            $priceList->importCsv();
            if($priceList->getPriceListProductPrice()->count()){
                return true;
                // Yii::$app->session->setFlash('success', "Your message to display.");
            }
        }
        return false;
    }
}
