<?php

namespace Bitcream\Corradi\Custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%customer_supplier}}".
 *
 * @property int $customer_id
 * @property int $supplier_id
 * @property int|null $payment_condition_id
 *
 * @property Customer $customer
 * @property PaymentCondition $paymentCondition
 * @property Supplier $supplier
 */
class CustomerSupplier extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%customer_supplier}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['customer_id', 'supplier_id'], 'required'],
            [['customer_id', 'supplier_id', 'payment_condition_id'], 'integer'],
            [['customer_id', 'supplier_id'], 'unique', 'targetAttribute' => ['customer_id', 'supplier_id']],
            [['customer_id'], 'exist', 'skipOnError' => true, 'targetClass' => Customer::className(), 'targetAttribute' => ['customer_id' => 'id']],
            [['payment_condition_id'], 'exist', 'skipOnError' => true, 'targetClass' => PaymentCondition::className(), 'targetAttribute' => ['payment_condition_id' => 'id']],
            [['supplier_id'], 'exist', 'skipOnError' => true, 'targetClass' => Supplier::className(), 'targetAttribute' => ['supplier_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'customer_id' => Yii::t('app', 'Customer ID'),
            'supplier_id' => Yii::t('app', 'Supplier ID'),
            'payment_condition_id' => Yii::t('app', 'Payment Condition ID'),
        ];
    }

    /**
     * Gets query for [[Customer]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCustomer()
    {
        return $this->hasOne(Customer::className(), ['id' => 'customer_id']);
    }

    /**
     * Gets query for [[PaymentCondition]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPaymentCondition()
    {
        return $this->hasOne(PaymentCondition::className(), ['id' => 'payment_condition_id']);
    }

    /**
     * Gets query for [[Supplier]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getSupplier()
    {
        return $this->hasOne(Supplier::className(), ['id' => 'supplier_id']);
    }
}
