<?php

namespace Bitcream\Corradi\Custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%price_list}}".
 *
 * @property int $id
 * @property string|null $name
 * @property int|null $supplier_id
 * @property int|null $is_active
 *
 * @property Customer[] $customers
 * @property OfferPriceList[] $offerPriceLists
 * @property Offer[] $offers
 * @property PriceListCustomer[] $priceListCustomers
 * @property PriceListProductPrice $priceListProductPrice
 * @property Supplier $supplier
 */
class PriceList extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%price_list}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['supplier_id', 'is_active'], 'integer'],
            [['name'], 'string', 'max' => 20],
            [['supplier_id'], 'exist', 'skipOnError' => true, 'targetClass' => Supplier::className(), 'targetAttribute' => ['supplier_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'name' => Yii::t('app', 'Name'),
            'supplier_id' => Yii::t('app', 'Supplier ID'),
            'is_active' => Yii::t('app', 'Is Active'),
        ];
    }

    /**
     * Gets query for [[Customers]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCustomers()
    {
        return $this->hasMany(Customer::className(), ['id' => 'customer_id'])->via('priceListCustomers');
    }

    /**
     * Gets query for [[OfferPriceLists]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOfferPriceLists()
    {
        return $this->hasMany(OfferPriceList::className(), ['price_list_id' => 'id']);
    }

    /**
     * Gets query for [[Offers]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOffers()
    {
        return $this->hasMany(Offer::className(), ['id' => 'offer_id'])->via('offerPriceLists');
    }

    /**
     * Gets query for [[PriceListCustomers]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPriceListCustomers()
    {
        return $this->hasMany(PriceListCustomer::className(), ['price_list_id' => 'id']);
    }

    /**
     * Gets query for [[PriceListProductPrice]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPriceListProductPrice()
    {
        return $this->hasOne(PriceListProductPrice::className(), ['price_list_id' => 'id']);
    }

    /**
     * Gets query for [[Supplier]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getSupplier()
    {
        return $this->hasOne(Supplier::className(), ['id' => 'supplier_id']);
    }
}
