<?php

namespace Bitcream\Corradi\Custom\console\migrations;

use yii\db\Migration;

/**
 * Handles the creation of table `{{%offer}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%supplier}}`
 * - `{{%customer}}`
 */
class M220923025832CreateOfferTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%offer}}', [
            'id' => $this->primaryKey(),
            'supplier_id' => $this->integer(),
            'customer_id' => $this->integer()->null(),
            'creation_date' => $this->timestamp(),
            'start_date' => $this->string(20),
            'minimum_value' => $this->string(255)->null(),
            'delivery_date' => $this->string(20)->null(),
            'delivery_terms' => $this->string(255)->null(),
            'return_condition' => $this->string(255)->null(),
            'tail_lift_required' => $this->boolean()->null(),
            'payment_condition' => $this->string(255)->null(),
            'payment_notes' => $this->text()->null(),
        ]);

        // creates index for column `supplier_id`
        $this->createIndex(
            '{{%idx-offer-supplier_id}}',
            '{{%offer}}',
            'supplier_id'
        );

        // add foreign key for table `{{%supplier}}`
        $this->addForeignKey(
            '{{%fk-offer-supplier_id}}',
            '{{%offer}}',
            'supplier_id',
            '{{%supplier}}',
            'id',
            'CASCADE'
        );

        // creates index for column `customer_id`
        $this->createIndex(
            '{{%idx-offer-customer_id}}',
            '{{%offer}}',
            'customer_id'
        );

        // add foreign key for table `{{%customer}}`
        $this->addForeignKey(
            '{{%fk-offer-customer_id}}',
            '{{%offer}}',
            'customer_id',
            '{{%customer}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%supplier}}`
        $this->dropForeignKey(
            '{{%fk-offer-supplier_id}}',
            '{{%offer}}'
        );

        // drops index for column `supplier_id`
        $this->dropIndex(
            '{{%idx-offer-supplier_id}}',
            '{{%offer}}'
        );

        // drops foreign key for table `{{%customer}}`
        $this->dropForeignKey(
            '{{%fk-offer-customer_id}}',
            '{{%offer}}'
        );

        // drops index for column `customer_id`
        $this->dropIndex(
            '{{%idx-offer-customer_id}}',
            '{{%offer}}'
        );

        $this->dropTable('{{%offer}}');
    }
}
