<?php

namespace Bitcream\Corradi\Custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%customer}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%customer_channel}}`
 */
class M221010011029AddCustomerChannelIdColumnToCustomerTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%customer}}', 'customer_channel_id', $this->integer()->null());

        // creates index for column `customer_channel_id`
        $this->createIndex(
            '{{%idx-customer-customer_channel_id}}',
            '{{%customer}}',
            'customer_channel_id'
        );

        // add foreign key for table `{{%customer_channel}}`
        $this->addForeignKey(
            '{{%fk-customer-customer_channel_id}}',
            '{{%customer}}',
            'customer_channel_id',
            '{{%customer_channel}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%customer_channel}}`
        $this->dropForeignKey(
            '{{%fk-customer-customer_channel_id}}',
            '{{%customer}}'
        );

        // drops index for column `customer_channel_id`
        $this->dropIndex(
            '{{%idx-customer-customer_channel_id}}',
            '{{%customer}}'
        );

        $this->dropColumn('{{%customer}}', 'customer_channel_id');
    }
}
