<?php

namespace bitcream\domicilio\custom\backend\models;

use Yii;
use bitcream\domicilio\custom\common\behaviors\StatusBehaviors;
use bitcream\domicilio\custom\common\behaviors\CreateUpdateBehaviors;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use yii\behaviors\SluggableBehavior;

/**
 * This is the model class for table "{{%category}}".
 *
 */
class Category extends \bitcream\domicilio\custom\common\models\Category
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            [
                'class' => SluggableBehavior::className(),
                'attribute' => 'title',
                'slugAttribute' => 'slug',
            ],
       ]);
    }
}
