<?php
namespace bitcream\domicilio\custom\backend\models;

use Yii;
use bitcream\domicilio\custom\common\behaviors\StatusBehaviors;
use bitcream\domicilio\custom\common\behaviors\CreateUpdateBehaviors;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use bitcream\domicilio\custom\backend\models\StoreCategory;
use bitcream\domicilio\custom\backend\models\StorePaymentMethod;
use yii\behaviors\BlameableBehavior;

/**
 * This is the model class for table "{{%store}}".
 *
 */
class Store extends \bitcream\domicilio\custom\common\models\Store
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'blameable' =>[
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'store_manager_id',
                'updatedByAttribute' => 'updated_user_id',
            ],
       ]);
    }

    /**
     * save Category
     */
    public function saveCategories($category_ids)
    {
        /* clear the Category of the post before saving */
        StoreCategory::deleteAll(['store_id' => $this->id]);
        if (is_array($category_ids)) {
            foreach($category_ids as $categoryId) {
                $spm = new StoreCategory();
                $spm->store_id = $this->id;
                $spm->category_id = $categoryId;
                $spm->save();
            }
        }
    }

    /**
     * save PaymentMethod
     */
    public function savePaymentMethods($payment_method_ids)
    {
        /* clear the PaymentMethod of the post before saving */
        StorePaymentMethod::deleteAll(['store_id' => $this->id]);
        if (is_array($payment_method_ids)) {
            foreach($payment_method_ids as $paymentMethodId) {
                $spm = new StorePaymentMethod();
                $spm->store_id = $this->id;
                $spm->payment_method_id = $paymentMethodId;
                $spm->save();
            }
        }
    }
}
