<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel bitcream\domicilio\custom\backend\models\DeliveryZoneMethodSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('domicilio', 'Delivery Zone Methods');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="delivery-zone-method-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(Yii::t('domicilio', 'Create Delivery Zone Method'), ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
            'status',
            'created_at',
            'created_user_id',
            'updated_at',
            //'updated_user_id',
            //'delivery_zone_id',
            //'delivery_method_id',

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>


</div>
