<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;
use yii\data\ActiveDataProvider;
use yii\helpers\Url;

use yiiui\yii2flagiconcss\widget\FlagIcon;
?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'delivery-zone-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'rowOptions' => function ($model, $key, $index, $grid) {
                return ['data-sortable-id' => $model->id];
            },
            'columns' => [
                ['attribute'=>Yii::t('domicilio', 'Name'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->name, [Yii::$app->controller->id.'/update','id'=>$data->id]);}
                ],
                [
                    'label' => Yii::t('domicilio', 'Store Title'),
                    'attribute'=>'store_id',
                    'value'=>'store.title',
                ],
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('domicilio', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                ]
            ],
            'options' => [
                'data' => [
                    'sortable-widget' => 1,
                    'sortable-url' => \yii\helpers\Url::toRoute(['sorting']),
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('domicilio',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
</div>