<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\select2\Select2;

/* @var $this yii\web\View */
/* @var $model bitcream\domicilio\custom\common\models\base\DeliveryZone */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="delivery-zone-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'day_hours_order')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <label class="control-label"><?=Yii::t('domicilio', 'Municipality');?></label>
            <?php echo Select2::widget([
                'name' => 'municipality_ids',
                'class' => 'form-group municipality form-control',
                'value' => ArrayHelper::map($model->municipalities, 'id', function ($municipality) {
                    return $municipality['id'];
                }),
                'id' => 'municipality',
                'data' => ArrayHelper::map($municipalities, 'id', function ($municipality) {
                    return $municipality['title'];
                }),
                'options' => ['multiple' => true, 'placeholder' => Yii::t('domicilio', 'Select municipality')]
            ]);?>
        </div>
    </div>

    <div class="row">
    <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'store_id')->dropDownList(
                ArrayHelper::map($store,'id',function($model) {
                    return $model['slug'];
                }),
                ['prompt' => "Seleziona il store"]
            )->label("Store")
            ?>
        </div>

    </div>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('domicilio', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>
    <?php
    if($model->id){
       echo $this->render('_form_method', [
            'model' => $model,
            // 'deliveryZoneMethod' => $deliveryZoneMethod,
            'deliveryMethod' => $deliveryMethod,
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
     }
    ?>
</div>
