<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use dosamigos\ckeditor\CKEditor;
use yii\helpers\ArrayHelper;
use kartik\select2\Select2;

/* @var $this yii\web\View */
/* @var $model bitcream\domicilio\custom\backend\models\Store */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="store-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'title')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'slug')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'phone_number')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'street')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'postal_code')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'municipality')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'province')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'web_site')->textInput(['maxlength' => true]) ?>
        </div>
    </div>     

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'facebook')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'instagram')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'whatsapp_number')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'booking_web_site')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'description')->widget(CKEditor::className(), [
                'options' => ['rows' => 3],
                'preset' => 'custom',
                'clientOptions' => [
                    'height' => 200,
                    'toolbarGroups' => [
                        ['name' => 'basicstyles', 'groups' => ['basicstyles', 'cleanup']],
                        ['name' => 'links', 'groups' => ['links']],
                    ],
                    'removeButtons' => 'Subscript,Superscript,Flash,Table,HorizontalRule,Smiley,SpecialChar,PageBreak,Iframe,Anchor,Strike',
                    'removePlugins' => 'elementspath',
                    'resize_enabled' => false
                ]
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <label class="control-label"><?=Yii::t('domicilio', 'Categories');?></label>
            <?php echo Select2::widget([
                'name' => 'category_ids',
                'class' => 'form-group category_ids form-control',
                'value' => ArrayHelper::map($model->categories, 'id', function ($category) {
                    return $category['id'];
                }),
                'id' => 'category_ids', 
                'data' => ArrayHelper::map($categories, 'id', function ($category) {
                    return $category['title'];
                }),
                'options' => ['multiple' => true, 'placeholder' => Yii::t('domicilio', 'Select categories')]    
            ]);?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'pre_payment')->checkbox([
                'label' => Yii::t('domicilio', 'Pre payment'),
                'checked' => (bool)$model->pre_payment,
                'class' => 'pre_payment',
            ]); ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <label class="control-label"><?=Yii::t('domicilio', 'Payment method');?></label>
            <?php echo Select2::widget([
                'name' => 'payment_method_ids',
                'class' => 'form-group payment_method form-control',
                'value' => ArrayHelper::map($model->paymentMethods, 'id', function ($paymentMethod) {
                    return $paymentMethod['id'];
                }),
                'id' => 'payment_method', 
                'data' => ArrayHelper::map($paymentMethods, 'id', function ($paymentMethod) {
                    return $paymentMethod['title'];
                }),
                'options' => ['multiple' => true, 'placeholder' => Yii::t('domicilio', 'Select payment method')]
            ]);?>
        </div>
    </div>

    <br>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('domicilio', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
