<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model bitcream\domicilio\custom\common\models\base\Store */

$this->title = $model->title;
$this->params['breadcrumbs'][] = ['label' => Yii::t('domicilio', 'Stores'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="store-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(Yii::t('domicilio', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a(Yii::t('domicilio', 'Delete'), ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => Yii::t('domicilio', 'Are you sure you want to delete this item?'),
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'title',
            'slug',
            'phone_number',
            'address_street',
            'address_code',
            'address_municipality',
            'address_province',
            'email:email',
            'web_address',
            'social_facebook',
            'social_instagram',
            'whatsapp_number',
            'booking_web_address',
            'cash',
            'credit_card',
            'atm',
            'satispay',
            'paypal',
            'pre_payment',
            'description:ntext',
            'created_at',
            'created_user_id',
            'updated_at',
            'updated_user_id',
        ],
    ]) ?>

</div>
