<?php

namespace bitcream\domicilio\custom\common\utils;
use Yii;

/**
 * This is the class for create menu left
 */
class Menu
{

    public static function general(){

        $items = array();

        $items = array_merge($items, Menu::applicationItems([]));


        // if (!empty($currentUserRoles["admin"])){
            //se l'utente è amministratore
            if(true){
                $items = array_merge($items, Menu::sysAdminItems());
            }
        // }
        return $items;
    }

    public static function applicationItems($params){

        return
        [
            [
                'label' => Yii::t('domicilio', 'Dashboard'),
                'url' => ['/'],
                'icon' => 'fontawesome fa fa-tachometer',
            ],
            [
                'label' => Yii::t('domicilio', 'Store'),
                'url' => ['/custom/store/index'],
                'icon' => 'fontawesome fa fa-shopping-cart',
            ],
            [
                'label' => Yii::t('domicilio', 'Category'),
                'url' => ['/custom/category/index'],
                'icon' => 'fontawesome fa fa-th',
            ],
            [
                'label' => Yii::t('domicilio', 'Municipality'),
                'url' => ['/custom/municipality/index'],
                'icon' => 'fontawesome fa fa-shopping-cart',
            ],
            [
                'label' => Yii::t('domicilio', 'DeliveryZone'),
                'url' => ['/custom/delivery-zone/index'],
                'icon' => 'fontawesome fa fa-shopping-cart',
            ],
        ];
    }


    public static function sysAdminItems(){
        return [
            [
                'label' => Yii::t('domicilio', 'SysAdmin'),
                'icon' => 'fontawesome fa fa-cogs',
                'url' => '#',
                'items' => [
                    [
                        'label' => Yii::t('domicilio', 'Payment method'),
                        'url' => ['/custom/payment-method/index'],
                        'icon' => 'fontawesome fa fa-money',
                    ],
                    [   'label' => Yii::t('domicilio', 'Users'),
                        'url' => ['/users/user/index'],
                        'icon' => 'fontawesome fa fa-user',
                    ],
                    [
                        'label' => Yii::t('domicilio', 'Users Permissions'),
                        'url' => ['/permissions/auth-item/auth'],
                        'icon' => 'fontawesome fa fa-user'
                    ],
                    [
                        'label' => Yii::t('domicilio', 'Users Roles'),
                        'url' => ['/permissions/auth-item/rule'],
                        'icon' => 'fontawesome fa fa-user'
                    ],
                    [   'label' => Yii::t('domicilio', 'Options'),
                        'url' => ['/options/option/index'],
                        'icon' => 'fontawesome fa fa-cog'
                    ],
                ]
            ]
        ];
    }

}
