<?php

namespace bitcream\domicilio\custom\console\controllers;

use Yii;
use yii\console\Controller;
use yii\console\ExitCode;

/**
 * Manage users module permissions
 */
class RbacController extends Controller
{
    public $defaultAction ="init";

   /**
     * Init users permissions and assign the permissions to role
     */

    public function actionInit()
    {

        $auth = Yii::$app->authManager;
        // $auth->removeAll();
        $rule = $auth->getRule('ViewOwnContent');
        if( empty($rule)){
        $rule = new \bitcream\domicilio\custom\common\models\ViewOwnContent;
        $auth->add($rule);
        }


        // add the "updateOwnPost" permission and associate the rule with it.
        $ViewOwnContent = $auth->getPermission('ViewOwnContent');
        if( empty($ViewOwnContent)){
              $ViewOwnContent  = $auth->createPermission('ViewOwnContent');
              $ViewOwnContent->description = 'visualizza solo il mio conetnte';
              $ViewOwnContent->ruleName = $rule->name;
              $auth->add($ViewOwnContent);
        };

        $adminRole = $auth->getRole('admin');
        if($adminRole){
            if(!$auth->hasChild($adminRole, $ViewOwnContent)){
                $auth->addChild($adminRole, $ViewOwnContent);
            }
        };

        return ExitCode::OK;
    }

}
