<?php

namespace bitcream\domicilio\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%store_payment_method}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%store_payment_method}}`
 */
class M210507143920AddStoreIdColumnToStorePaymentMethodTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%store_payment_method}}', 'store_id', $this->integer()->null());

        // creates index for column `store_id`
        $this->createIndex(
            '{{%idx-store_payment_method-store_id}}',
            '{{%store_payment_method}}',
            'store_id'
        );

        // add foreign key for table `{{%store}}`
        $this->addForeignKey(
            '{{%fk-store_payment_method-store_id}}',
            '{{%store_payment_method}}',
            'store_id',
            '{{%store}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%store}}`
        $this->dropForeignKey(
            '{{%fk-store_payment_method-store_id}}',
            '{{%store_payment_method}}'
        );

        // drops index for column `store_id`
        $this->dropIndex(
            '{{%idx-store_payment_method-store_id}}',
            '{{%store_payment_method}}'
        );

        $this->dropColumn('{{%store_payment_method}}', 'store_id');
    }
}
