<?php

namespace bitcream\domicilio\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%store_category}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%category}}`
 */
class M210510140606AddCategoryIdColumnToStoreCategoryTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%store_category}}', 'category_id', $this->integer()->null());

        // creates index for column `category_id`
        $this->createIndex(
            '{{%idx-store_category-category_id}}',
            '{{%store_category}}',
            'category_id'
        );

        // add foreign key for table `{{%category}}`
        $this->addForeignKey(
            '{{%fk-store_category-category_id}}',
            '{{%store_category}}',
            'category_id',
            '{{%category}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%category}}`
        $this->dropForeignKey(
            '{{%fk-store_category-category_id}}',
            '{{%store_category}}'
        );

        // drops index for column `category_id`
        $this->dropIndex(
            '{{%idx-store_category-category_id}}',
            '{{%store_category}}'
        );

        $this->dropColumn('{{%store_category}}', 'category_id');
    }
}
