<?php

namespace bitcream\domicilio\custom\api\controllers;

use yii\rest\ActiveController;
use bitcream\domicilio\custom\api\models\Store;
use Yii;
use yii\db\Query;
use yii\data\ActiveDataFilter;
use yii\data\ActiveDataProvider;
 
class StoreController extends ActiveController
{
    public $modelClass = 'bitcream\domicilio\custom\api\models\Store';

    public function actions(){
        $actions = parent::actions();

        $actions['index']['prepareDataProvider'] = [$this, 'prepareDataProvider'];

        return $actions;
    }

    public function prepareDataProvider(){

        $filter = new ActiveDataFilter([
            'searchModel' => 'bitcream\domicilio\custom\api\models\StoreSearch'
        ]);
        
        $filterCondition = null;
        
        // You may load filters from any source. For example,
        // if you prefer JSON in request body,
        // use Yii::$app->request->getBodyParams() below:
        if ($filter->load(\Yii::$app->request->get())) { 
            $filterCondition = $filter->build();
            if ($filterCondition === false) {
                // Serializer would get errors out of it
                return $filter;
            }
        }
        
        $query = Store::find();
        if ($filterCondition !== null) {
            $query->andWhere($filterCondition);
        }
        
        return new ActiveDataProvider([
            'query' => $query,
        ]);
    }   
}
