<?php

namespace bitcream\domicilio\custom\backend\controllers;

use Yii;
use bitcream\domicilio\custom\backend\models\Store;
use bitcream\domicilio\custom\backend\models\Category;
use bitcream\domicilio\custom\backend\models\StoreWithCategoryAndPayment;
use bitcream\domicilio\custom\backend\models\PaymentMethod;
use bitcream\domicilio\custom\backend\models\StoreSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * StoreController implements the CRUD actions for Store model.
 */
class StoreController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Store models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new StoreSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Store model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Store model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Store();

        if ($model->load(Yii::$app->request->post())) {
            $model->pre_payment = (isset($model->pre_payment) && $model->pre_payment == 1)? true : false;

            $model->save(false);
            $model->saveCategories(Yii::$app->request->post()['category_ids']);
            $model->savePaymentMethods(Yii::$app->request->post()['payment_method_ids']);
            return $this->redirect(['index']);
        }

        return $this->render('create', [
            'model' => $model,
            'categories' =>  Category::find()->all(),
            'paymentMethods' =>  PaymentMethod::find()->all(),
        ]);
    }

    /**
     * Updates an existing Store model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $model->pre_payment = (isset($model->pre_payment) && $model->pre_payment == 1)? true : false;

        if ($model->load(Yii::$app->request->post())) {
            $model->save(false);
            $model->saveCategories(Yii::$app->request->post()['category_ids']);
            $model->savePaymentMethods(Yii::$app->request->post()['payment_method_ids']);
            return $this->redirect(['index']);
        }

        return $this->render('update', [
            'model' => $model,
            'categories' =>  Category::find()->all(),
            'paymentMethods' =>  PaymentMethod::find()->all(),
        ]);
    }

    /**
     * Deletes an existing Store model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Store model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Store the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Store::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('domicilio', 'The requested page does not exist.'));
    }
}
