<?php

namespace bitcream\domicilio\custom\backend\models;

use Yii;
use bitcream\domicilio\custom\common\behaviors\StatusBehaviors;
use bitcream\domicilio\custom\common\behaviors\CreateUpdateBehaviors;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use yii\behaviors\SluggableBehavior;
// use bitcream\domicilio\custom\common\behaviors\ResizeBehaviors;
use yii\helpers\ArrayHelper;
/**
 * This is the model class for table "{{%category}}".
 *
 */
class Category extends \bitcream\domicilio\custom\common\models\Category
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'files' => [
                'class' => 'floor12\files\components\FileBehaviour',
                'attributes' => [
                    'cover',
                    'icone',
                    'image_seo',
                ],
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            [
                'class' => SluggableBehavior::className(),
                'attribute' => 'title',
                'slugAttribute' => 'slug',
            ],
            // 'imagine' => [
            //     'class' => ResizeBehaviors::className(),
            //     'attributes' => [
            //         'cover'
            //     ],
            // ],
       ]);
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [
            // each category_id must exist in category table (*1)
            ['cover', 'file', 'extensions' => ['jpg', 'png', 'jpeg', 'gif'], 'maxFiles' => 1],
            ['icone', 'file', 'extensions' => ['jpg', 'png', 'jpeg', 'gif'], 'maxFiles' => 1],
            ['image_seo', 'file', 'extensions' => ['jpg', 'png', 'jpeg', 'gif'], 'maxFiles' => 1],
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [
            'cover' => Yii::t('domicilio', 'Cover'),
            'icone' => Yii::t('domicilio', 'Icone'),
            'image_seo' => Yii::t('domicilio', 'Image Seo'),
        ]);
    }
}
