<?php

namespace bitcream\domicilio\custom\backend\models;

use Yii;
use bitcream\domicilio\custom\common\behaviors\CreateUpdateBehaviors;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use bitcream\domicilio\custom\common\behaviors\StatusBehaviors;


/**
 * This is the model class for table "{{%DeliveryMethod}}".
 *
 */
class DeliveryMethod extends \bitcream\domicilio\custom\common\models\DeliveryMethod
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
       ]);
    }

    public static function deleteDeliveryMethod($id){
        $model = DeliveryMethod::findOne($id);
        $model->delete();
    }

}
