<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use emberware\evidia\datatable\common\models\DataTableCustom;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $model bitcream\domicilio\event\backend\models\Event */
/* @var $form yii\widgets\ActiveForm */
// print_r($model->eventFaculty);
// exit();
?>
<hr>
<h3><?= Yii::t('domicilio', 'Add cost')?></h3>
<div class="zone-form">

    <?php $form = ActiveForm::begin([

    'id' => 'zone-form',
    'action' => ['save-zone-method'],
    ]); ?>

    <div class="row">
        <div class="col-md-3 col-xs-5">
            <?= $form->field($deliveryMethod, 'cost')->textInput(['maxlength' => true])?>
        </div>

        <div class="col-md-3 col-xs-5">
            <?= $form->field($deliveryMethod, 'minimum_expense')->textInput(['maxlength' => true])?>
        </div>

        <div class="col-md-3 col-xs-2">
            <div class="form-group">
                <br>
                <input id="delivery_zone_id" name="delivery_zone_id" type="hidden" value="<?=$model->id?>">
                <?= Html::submitButton(Yii::t('domicilio', 'Add'), ['class' => 'btn btn-success']) ?>
            </div>
        </div>
    </div>

    <?php ActiveForm::end();?>

    <?php

    // $module = Yii::$app->controller->module->id;
    // print_r($module);

    // exit();?>
    <div class="datatable">
        <?=
            DataTableCustom::widget([
                'dataProvider' => $dataProvider,
                'id' => 'event-faculty-table',
                //'searchModel' => $searchModel,
                'columns' => [
                    // ['class' => '\yii\grid\SerialColumn'],
                    [
                        'label' => Yii::t('domicilio', 'Costo'),
                        'attribute'=>'cost',
                        'value' => 'deliveryMethod.cost'
                    ],
                    [
                        'label' => Yii::t('domicilio', 'Spesa minima'),
                        'attribute'=>'minimum_expense',
                        'value' => 'deliveryMethod.minimum_expense'
                    ],
                    [
                        'attribute'=>Yii::t('domicilio', 'Actions'),
                        'format'=>'raw',
                        'value' => function($data)
                        {return Html::a("<i class='fa fa-trash-o'></i>", [Yii::$app->controller->id.'/delete-delivery-zone-method','id'=>$data->id, 'delivery_method_id' => $data->delivery_method_id, 'delivery_zone_id' => $data->delivery_zone_id], ['data' => ['confirm' => Yii::t('app', 'Do you whant delete this faculty?'),'method' => 'post']]); }
                    ]
                ],
                'clientOptions' => [
                    "responsive"=>true,
                    "language" => [
                        "url" => Yii::t('domicilio', "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                    ]
                ]
            ]);
        ?>
    </div>



</div>
