<?php

namespace bitcream\domicilio\custom\common\models\base;

use bitcream\domicilio\custom\common\models\StoreManager;
use Yii;

/**
 * This is the model class for table "{{%store}}".
 *
 * @property int $id
 * @property string|null $title
 * @property string|null $slug
 * @property string|null $phone_number
 * @property string|null $street
 * @property string|null $postal_code
 * @property string|null $municipality
 * @property string|null $province
 * @property string|null $email
 * @property string|null $web_site
 * @property string|null $facebook
 * @property string|null $instagram
 * @property string|null $whatsapp_number
 * @property string|null $booking_web_site
 * @property int|null $pre_payment
 * @property string|null $description
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property int|null $store_manager_id
 *
 * @property DeliveryZone[] $deliveryZones
 * @property StoreCategory[] $storeCategories
 * @property StorePaymentMethod[] $storePaymentMethods
 */
class Store extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%store}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['pre_payment', 'status', 'created_user_id', 'updated_user_id', 'store_manager_id'], 'integer'],
            [['description'], 'string'],
            [['title', 'slug', 'phone_number', 'street', 'postal_code', 'municipality', 'province', 'email', 'web_site', 'facebook', 'instagram', 'whatsapp_number', 'booking_web_site', 'created_at', 'updated_at'], 'string', 'max' => 255],
            [['store_manager_id'], 'exist', 'skipOnError' => true, 'targetClass' => StoreManager::className(), 'targetAttribute' => ['store_manager_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('domicilio', 'ID'),
            'title' => Yii::t('domicilio', 'Title'),
            'slug' => Yii::t('domicilio', 'Slug'),
            'phone_number' => Yii::t('domicilio', 'Phone Number'),
            'street' => Yii::t('domicilio', 'Street'),
            'postal_code' => Yii::t('domicilio', 'Postal Code'),
            'municipality' => Yii::t('domicilio', 'Municipality'),
            'province' => Yii::t('domicilio', 'Province'),
            'email' => Yii::t('domicilio', 'Email'),
            'web_site' => Yii::t('domicilio', 'Web Site'),
            'facebook' => Yii::t('domicilio', 'Facebook'),
            'instagram' => Yii::t('domicilio', 'Instagram'),
            'whatsapp_number' => Yii::t('domicilio', 'Whatsapp Number'),
            'booking_web_site' => Yii::t('domicilio', 'Booking Web Site'),
            'pre_payment' => Yii::t('domicilio', 'Pre Payment'),
            'description' => Yii::t('domicilio', 'Description'),
            'status' => Yii::t('domicilio', 'Status'),
            'created_at' => Yii::t('domicilio', 'Created At'),
            'created_user_id' => Yii::t('domicilio', 'Created User ID'),
            'updated_at' => Yii::t('domicilio', 'Updated At'),
            'updated_user_id' => Yii::t('domicilio', 'Updated User ID'),
            'store_manager_id' => Yii::t('domicilio', 'Store Manager ID'),
        ];
    }

    /**
     * Gets query for [[DeliveryZones]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getDeliveryZones()
    {
        return $this->hasMany(DeliveryZone::className(), ['store_id' => 'id'])->inverseOf('store');
    }

    /**
     * Gets query for [[StoreCategories]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getStoreCategories()
    {
        return $this->hasMany(StoreCategory::className(), ['store_id' => 'id'])->inverseOf('store');
    }

    /**
     * Gets query for [[StorePaymentMethods]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getStorePaymentMethods()
    {
        return $this->hasMany(StorePaymentMethod::className(), ['store_id' => 'id'])->inverseOf('store');
    }
}
