<?php

namespace bitcream\domicilio\custom\console\controllers;

use Yii;
use yii\console\Controller;
use yii\console\ExitCode;

/**
 * Manage users module permissions
 */
class RbacController extends Controller
{
    public $defaultAction ="init";

   /**
     * Init users permissions and assign the permissions to role
     */

    public function actionInit()
    {

        $auth = Yii::$app->authManager;
        // $auth->removeAll();
        $rule = $auth->getRule('ViewOwnContent');
        if( empty($rule)){
        $rule = new \bitcream\domicilio\custom\common\models\ViewOwnContent;
        $auth->add($rule);
        }


        // add the "updateOwnPost" permission and associate the rule with it.
        $ViewOwnContent = $auth->getPermission('ViewOwnContent');
        if( empty($ViewOwnContent)){
              $ViewOwnContent  = $auth->createPermission('ViewOwnContent');
              $ViewOwnContent->description = 'visualizza solo il mio conetnte';
              $ViewOwnContent->ruleName = $rule->name;
              $auth->add($ViewOwnContent);
        };

        // add "viewStoreManagerMenu" permission
        $viewStoreMenu = $auth->getPermission('viewStoreMenu');
        if( empty($viewStoreMenu)){
            $viewStoreMenu = $auth->createPermission('viewStoreMenu');
            $viewStoreMenu->description = 'visualizza store menu';
            $auth->add($viewStoreMenu);
        };
        // add "viewSysadminMenu" permission
        $viewSysadminMenu = $auth->getPermission('viewSysadminMenu');
        if( empty($viewSysadminMenu)){
            $viewSysadminMenu = $auth->createPermission('viewSysadminMenu');
            $viewSysadminMenu->description = 'permesso per menu di sistema';
            $auth->add($viewSysadminMenu);
        }

        $storeManager = $auth->getRole('storeManager');
        if( empty($storeManager)){
            $storeManager = $auth->createRole('storeManager');
            $storeManager->description = 'ruolo store manager';
            $auth->add($storeManager);
        }

        $adminRole = $auth->getRole('admin');
        if($adminRole){
            if(!$auth->hasChild($adminRole, $ViewOwnContent)){
                $auth->addChild($adminRole, $ViewOwnContent);
            }
            if(!$auth->hasChild($adminRole, $viewStoreMenu)){
                $auth->addChild($adminRole, $viewStoreMenu);
            }
            if(!$auth->hasChild($adminRole, $viewSysadminMenu)){
                $auth->addChild($adminRole, $viewSysadminMenu);
            }
        };

        return ExitCode::OK;
    }

}
