<?php

namespace bitcream\domicilio\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%store_category}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%store}}`
 */
class M210510135822AddStoreIdColumnToStoreCategoryTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%store_category}}', 'store_id', $this->integer()->null());

        // creates index for column `store_id`
        $this->createIndex(
            '{{%idx-store_category-store_id}}',
            '{{%store_category}}',
            'store_id'
        );

        // add foreign key for table `{{%store}}`
        $this->addForeignKey(
            '{{%fk-store_category-store_id}}',
            '{{%store_category}}',
            'store_id',
            '{{%store}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%store}}`
        $this->dropForeignKey(
            '{{%fk-store_category-store_id}}',
            '{{%store_category}}'
        );

        // drops index for column `store_id`
        $this->dropIndex(
            '{{%idx-store_category-store_id}}',
            '{{%store_category}}'
        );

        $this->dropColumn('{{%store_category}}', 'store_id');
    }
}
