<?php

namespace bitcream\domicilio\custom\api\models;

use Yii;

/**
 * This is the model class for table "{{%DeliveryZone}}".
 *
 */
class DeliveryZone extends \bitcream\domicilio\custom\common\models\DeliveryZone
{
    public function fields(){
        return [
            'id',
            'name',
            'day_hours_order',
            'delivery_methods' => "deliveryMethods",
            'municipalities' => "municipalities"
        ];
    }

    public function getDeliveryMethods()
    {
        return $this->hasMany(DeliveryMethod::className(), ['id' => 'delivery_method_id'])
            ->via('deliveryZoneMethods');
    }

    public function getMunicipalities()
    {
        return $this->hasMany(Municipality::className(), ['id' => 'municipality_id'])
            ->via('municipalityDeliveryZones');
    }

}
