<?php

namespace bitcream\domicilio\custom\api\models;

use Yii;
use bitcream\domicilio\custom\common\models\MunicipalityDeliveryZone;
/**
 * This is the model class for table "{{%store}}".
 *
 */
class Store extends \bitcream\domicilio\custom\common\models\Store
{
    public function fields(){
        return [
            'id',
            'title',
            'slug',
            'description',
            'phone_number',
            'address' => function ($model){
                return [
                    'street' => $this->street,
                    'postal_code' => $this->postal_code,
                    'municipality' => $this->municipality,
                    'province' => $this->province,
                    'longitude' => $this->longitude,
                    'latitude' => $this->latitude,
                ];
            },
            'email',
            'web_site',
            'social' => function ($model){
                return [
                    'facebook' => $this->facebook,
                    'instagram' => $this->instagram,
                ];
            },
            'whatsapp' => 'whatsapp_number',
            'online_booking' => function ($model){
                return [
                            [
                                'url' => $this->booking_web_site,
                            ]
                ];
            },
            'categories' => 'categories',
            'pre_payment' => function ($model){
                return (bool)$this->pre_payment;
            },
            'payment_methods' => 'paymentMethods',
            'delivery_zones' => 'deliveryZones',
        ];
    }

    /**
     * Gets query for [[StoreCategories]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCategories()
    {
        return $this->hasMany(Category::className(), ['id' => 'category_id'])
            ->via('storeCategories');
    }

    /**
     * Gets query for [[StoreCategories]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getStoreCategories()
    {
        return $this->hasMany(StoreCategory::className(), ['store_id' => 'id'])->inverseOf('store');
    }

    public function getPaymentMethods()
    {
        return $this->hasMany(PaymentMethod::className(), ['id' => 'payment_method_id'])
            ->via('storePaymentMethods');
    }

    /**
     * Gets query for [[StorePaymentMethods]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getStorePaymentMethods()
    {
        return $this->hasMany(StorePaymentMethod::className(), ['store_id' => 'id'])->inverseOf('store');
    }

      /**
     * Gets query for [[DeliveryZones]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getDeliveryZones()
    {
        return $this->hasMany(DeliveryZone::className(), ['store_id' => 'id'])->inverseOf('store');
    }

    /**
     * Gets query for [[MunicipalityDeliveryZones]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMunicipalityDeliveryZones()
    {
        return $this->hasMany(MunicipalityDeliveryZone::className(), ['delivery_zone_id' => 'id'])
            ->via('deliveryZones');
        //eturn $this->hasMany(MunicipalityDeliveryZone::className(), ['store_id' => 'id']);
    }

    public function getMunicipalities()
    {
        return $this->hasMany(Municipality::className(), ['id' => 'municipality_id'])
            ->via('municipalityDeliveryZones');
    }

    public static function searchByKey($keyVal, $array) {
        foreach ($array as $key => $val) {
            if ($keyVal == $key) {
              $resultSet['key'] = $key;
              return $resultSet;
            }
        }
        return null;
     }
}
