<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use dosamigos\ckeditor\CKEditor;
use kartik\select2\Select2;

/* @var $this yii\web\View */
/* @var $model bitcream\domicilio\custom\common\models\base\Category */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="category-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'title')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'description')->widget(CKEditor::className(), [
                'options' => ['rows' => 3],
                'preset' => 'custom',
                'clientOptions' => [
                    'height' => 200,
                    'toolbarGroups' => [
                        ['name' => 'basicstyles', 'groups' => ['basicstyles', 'cleanup']],
                        ['name' => 'links', 'groups' => ['links']],
                    ],
                    'removeButtons' => 'Subscript,Superscript,Flash,Table,HorizontalRule,Smiley,SpecialChar,PageBreak,Iframe,Anchor,Strike',
                    'removePlugins' => 'elementspath',
                    'resize_enabled' => false
                ]
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'secondary_terms')->widget(CKEditor::className(), [
                'options' => ['rows' => 3],
                'preset' => 'custom',
                'clientOptions' => [
                    'height' => 200,
                    'toolbarGroups' => [
                        ['name' => 'basicstyles', 'groups' => ['basicstyles', 'cleanup']],
                        ['name' => 'links', 'groups' => ['links']],
                    ],
                    'removeButtons' => 'Subscript,Superscript,Flash,Table,HorizontalRule,Smiley,SpecialChar,PageBreak,Iframe,Anchor,Strike',
                    'removePlugins' => 'elementspath',
                    'resize_enabled' => false
                ]
            ]) ?>
        </div>
    </div>
    <hr>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'seo_title')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'seo_description')->widget(CKEditor::className(), [
                'options' => ['rows' => 3],
                'preset' => 'custom',
                'clientOptions' => [
                    'height' => 200,
                    'toolbarGroups' => [
                        ['name' => 'basicstyles', 'groups' => ['basicstyles', 'cleanup']],
                        ['name' => 'links', 'groups' => ['links']],
                    ],
                    'removeButtons' => 'Subscript,Superscript,Flash,Table,HorizontalRule,Smiley,SpecialChar,PageBreak,Iframe,Anchor,Strike',
                    'removePlugins' => 'elementspath',
                    'resize_enabled' => false
                ]
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'seo_keywords')->widget(CKEditor::className(), [
                'options' => ['rows' => 3],
                'preset' => 'custom',
                'clientOptions' => [
                    'height' => 200,
                    'toolbarGroups' => [
                        ['name' => 'basicstyles', 'groups' => ['basicstyles', 'cleanup']],
                        ['name' => 'links', 'groups' => ['links']],
                    ],
                    'removeButtons' => 'Subscript,Superscript,Flash,Table,HorizontalRule,Smiley,SpecialChar,PageBreak,Iframe,Anchor,Strike',
                    'removePlugins' => 'elementspath',
                    'resize_enabled' => false
                ]
            ]) ?>
        </div>
    </div>
    <br>
    <h3><?=Yii::t('domicilio', 'Uploading Cover')?></h3>
    <?=$form->field($model, 'cover')->widget(floor12\files\components\FileInputWidget::class) ?>

    <br>
    <h3><?=Yii::t('domicilio', 'Uploading Icone')?></h3>
    <?=$form->field($model, 'icone')->widget(floor12\files\components\FileInputWidget::class) ?>

    <br>
    <h3><?=Yii::t('domicilio', 'Uploading Image Seo')?></h3>
    <?=$form->field($model, 'image_seo')->widget(floor12\files\components\FileInputWidget::class) ?>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('domicilio', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
