<?php
namespace bitcream\domicilio\custom\common\behaviors;

use yii\base\Behavior;
use yii\db\ActiveRecord;
use yii\imagine\Image;
use Yii;

class ResizeBehaviors extends Behavior
{
    public $attributes = [];
    /**
     * event set status
     */
    public function events()
    {
        return [
            ActiveRecord::EVENT_BEFORE_INSERT => 'resizeImages',
            ActiveRecord::EVENT_BEFORE_UPDATE => 'resizeImages',
        ];
    }

    public function resizeImages(){

        foreach ($this->attributes as $attribute) {
            if(!is_array($this->owner->$attribute)){
                $this->resizeImage($this->owner->$attribute);
            }else{
                foreach($this->owner->$attribute as $file){
                    $this->resizeImage($file);
                }
            }
        }
    }

    public function resizeImage($file){

        if(empty($file->filename)) return;

        $filePath = Yii::getAlias(Yii::$app->params['file_storage']).$file->filename;
        Image::resize($filePath , 1920, 1080)
                        ->save($filePath, ['quality' => 80]);
    }
}