<?php

namespace bitcream\domicilio\custom\common\models;

use Yii;

/**
 * This is the model class for table "{{%store}}".
 * @property StoreManager $storeManager
 * @property Category[] $categories
 * @property PaymentMethod[] $paymentMethods
 */
class Store extends base\Store
{
    public function getCategories()
    {
        return $this->hasMany(Category::className(), ['id' => 'category_id'])
            ->via('storeCategories');
    }

    public function getPaymentMethods()
    {
        return $this->hasMany(PaymentMethod::className(), ['id' => 'payment_method_id'])
            ->via('storePaymentMethods');
    }

     /**
     * Gets query for [[StoreManager]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getStoreManager()
    {
        return $this->hasOne(StoreManager::className(), ['id' => 'store_manager_id'])->inverseOf('stores');
    }

}
