<?php

namespace bitcream\domicilio\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%category}}".
 *
 * @property int $id
 * @property string|null $title
 * @property string|null $slug
 * @property string|null $description
 * @property string|null $secondary_terms
 * @property string|null $seo_title
 * @property string|null $seo_description
 * @property string|null $seo_keywords
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 *
 * @property StoreCategory[] $storeCategories
 */
class Category extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%category}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['description', 'secondary_terms', 'seo_description', 'seo_keywords'], 'string'],
            [['status', 'created_user_id', 'updated_user_id'], 'integer'],
            [['title', 'slug', 'seo_title', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('domicilio', 'ID'),
            'title' => Yii::t('domicilio', 'Title'),
            'slug' => Yii::t('domicilio', 'Slug'),
            'description' => Yii::t('domicilio', 'Description'),
            'secondary_terms' => Yii::t('domicilio', 'Secondary Terms'),
            'seo_title' => Yii::t('domicilio', 'Seo Title'),
            'seo_description' => Yii::t('domicilio', 'Seo Description'),
            'seo_keywords' => Yii::t('domicilio', 'Seo Keywords'),
            'status' => Yii::t('domicilio', 'Status'),
            'created_at' => Yii::t('domicilio', 'Created At'),
            'created_user_id' => Yii::t('domicilio', 'Created User ID'),
            'updated_at' => Yii::t('domicilio', 'Updated At'),
            'updated_user_id' => Yii::t('domicilio', 'Updated User ID'),
        ];
    }

    /**
     * Gets query for [[StoreCategories]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getStoreCategories()
    {
        return $this->hasMany(StoreCategory::className(), ['category_id' => 'id'])->inverseOf('category');
    }
}
