<?php

namespace bitcream\domicilio\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "delivery_zone_method".
 *
 * @property int $id
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property int|null $delivery_zone_id
 * @property int|null $delivery_method_id
 *
 * @property DeliveryMethod $deliveryMethod
 * @property DeliveryZone $deliveryZone
 */
class DeliveryZoneMethod extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'delivery_zone_method';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['status', 'created_user_id', 'updated_user_id', 'delivery_zone_id', 'delivery_method_id'], 'integer'],
            [['created_at', 'updated_at'], 'string', 'max' => 255],
            [['delivery_method_id'], 'exist', 'skipOnError' => true, 'targetClass' => DeliveryMethod::className(), 'targetAttribute' => ['delivery_method_id' => 'id']],
            [['delivery_zone_id'], 'exist', 'skipOnError' => true, 'targetClass' => DeliveryZone::className(), 'targetAttribute' => ['delivery_zone_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('domicilio', 'ID'),
            'status' => Yii::t('domicilio', 'Status'),
            'created_at' => Yii::t('domicilio', 'Created At'),
            'created_user_id' => Yii::t('domicilio', 'Created User ID'),
            'updated_at' => Yii::t('domicilio', 'Updated At'),
            'updated_user_id' => Yii::t('domicilio', 'Updated User ID'),
            'delivery_zone_id' => Yii::t('domicilio', 'Delivery Zone ID'),
            'delivery_method_id' => Yii::t('domicilio', 'Delivery Method ID'),
        ];
    }

    /**
     * Gets query for [[DeliveryMethod]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getDeliveryMethod()
    {
        return $this->hasOne(DeliveryMethod::className(), ['id' => 'delivery_method_id'])->inverseOf('deliveryZoneMethods');
    }

    /**
     * Gets query for [[DeliveryZone]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getDeliveryZone()
    {
        return $this->hasOne(DeliveryZone::className(), ['id' => 'delivery_zone_id'])->inverseOf('deliveryZoneMethods');
    }
}
