<?php

namespace bitcream\domicilio\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "municipality_delivery_zone".
 *
 * @property int $id
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property int|null $municipality_id
 * @property int|null $delivery_zone_id
 *
 * @property DeliveryZone $deliveryZone
 * @property Municipality $municipality
 */
class MunicipalityDeliveryZone extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'municipality_delivery_zone';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['status', 'created_user_id', 'updated_user_id', 'municipality_id', 'delivery_zone_id'], 'integer'],
            [['created_at', 'updated_at'], 'string', 'max' => 255],
            [['delivery_zone_id'], 'exist', 'skipOnError' => true, 'targetClass' => DeliveryZone::className(), 'targetAttribute' => ['delivery_zone_id' => 'id']],
            [['municipality_id'], 'exist', 'skipOnError' => true, 'targetClass' => Municipality::className(), 'targetAttribute' => ['municipality_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('domicilio', 'ID'),
            'status' => Yii::t('domicilio', 'Status'),
            'created_at' => Yii::t('domicilio', 'Created At'),
            'created_user_id' => Yii::t('domicilio', 'Created User ID'),
            'updated_at' => Yii::t('domicilio', 'Updated At'),
            'updated_user_id' => Yii::t('domicilio', 'Updated User ID'),
            'municipality_id' => Yii::t('domicilio', 'Municipality ID'),
            'delivery_zone_id' => Yii::t('domicilio', 'Delivery Zone ID'),
        ];
    }

    /**
     * Gets query for [[DeliveryZone]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getDeliveryZone()
    {
        return $this->hasOne(DeliveryZone::className(), ['id' => 'delivery_zone_id'])->inverseOf('municipalityDeliveryZones');
    }

    /**
     * Gets query for [[Municipality]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMunicipality()
    {
        return $this->hasOne(Municipality::className(), ['id' => 'municipality_id'])->inverseOf('municipalityDeliveryZones');
    }
}
