<?php

namespace bitcream\domicilio\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%municipality_delivery_zone}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%municipality}}`
 */
class M210511100754AddMunicipalityIdColumnToMunicipalityDeliveryZoneTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%municipality_delivery_zone}}', 'municipality_id', $this->integer()->null());

        // creates index for column `municipality_id`
        $this->createIndex(
            '{{%idx-municipality_delivery_zone-municipality_id}}',
            '{{%municipality_delivery_zone}}',
            'municipality_id'
        );

        // add foreign key for table `{{%municipality}}`
        $this->addForeignKey(
            '{{%fk-municipality_delivery_zone-municipality_id}}',
            '{{%municipality_delivery_zone}}',
            'municipality_id',
            '{{%municipality}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%municipality}}`
        $this->dropForeignKey(
            '{{%fk-municipality_delivery_zone-municipality_id}}',
            '{{%municipality_delivery_zone}}'
        );

        // drops index for column `municipality_id`
        $this->dropIndex(
            '{{%idx-municipality_delivery_zone-municipality_id}}',
            '{{%municipality_delivery_zone}}'
        );

        $this->dropColumn('{{%municipality_delivery_zone}}', 'municipality_id');
    }
}
