<?php

namespace bitcream\domicilio\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%delivery_zone_method}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%delivery_method}}`
 */
class M210511122107AddDeliveryMethodIdColumnToDeliveryZoneMethodTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%delivery_zone_method}}', 'delivery_method_id', $this->integer()->null());

        // creates index for column `delivery_method_id`
        $this->createIndex(
            '{{%idx-delivery_zone_method-delivery_method_id}}',
            '{{%delivery_zone_method}}',
            'delivery_method_id'
        );

        // add foreign key for table `{{%delivery_method}}`
        $this->addForeignKey(
            '{{%fk-delivery_zone_method-delivery_method_id}}',
            '{{%delivery_zone_method}}',
            'delivery_method_id',
            '{{%delivery_method}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%delivery_method}}`
        $this->dropForeignKey(
            '{{%fk-delivery_zone_method-delivery_method_id}}',
            '{{%delivery_zone_method}}'
        );

        // drops index for column `delivery_method_id`
        $this->dropIndex(
            '{{%idx-delivery_zone_method-delivery_method_id}}',
            '{{%delivery_zone_method}}'
        );

        $this->dropColumn('{{%delivery_zone_method}}', 'delivery_method_id');
    }
}
