<?php
namespace bitcream\domicilio\custom\api\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use bitcream\domicilio\custom\api\models\Store;

/**
 * StoreSearch represents the model behind the search form of `bitcream\domicilio\custom\backend\models\Store`.
 */
class StoreSearch extends Store
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'pre_payment', 'status', 'created_user_id', 'updated_user_id'], 'integer'],
            [['municipality.id','municipality.title','municipality.slug','category.id','category.title','category.slug','title', 'slug', 'phone_number', 'street', 'postal_code', 'municipality', 'province', 'email', 'web_site', 'facebook', 'instagram', 'whatsapp_number', 'booking_web_site', 'description', 'created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
	 * @return array
	 */
	public function attributes()
	{
		return array_merge(parent::attributes(), [
            'category.id',
            'category.title',
            'category.slug',
            'municipality.id',
            'municipality.title',
            'municipality.slug',
        ]);
	}

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Store::find();        

        // add conditions that should always apply here
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        if(isset($params['per-page'])){
            $dataProvider->pagination = ['pageSize' => $params['per-page']];
        }

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $dataProvider->sort->attributes['category.id'] = [
            'asc' => ['category.id' => SORT_ASC],
            'desc' => ['category.id' => SORT_DESC],
        ];

        $dataProvider->sort->attributes['municipality.id'] = [
            'asc' => ['municipality.id' => SORT_ASC],
            'desc' => ['municipality.id' => SORT_DESC],
        ];

        $dataProvider->sort->attributes['category.title'] = [
            'asc' => ['category.title' => SORT_ASC],
            'desc' => ['category.title' => SORT_DESC],
        ];

        $dataProvider->sort->attributes['municipality.title'] = [
            'asc' => ['municipality.title' => SORT_ASC],
            'desc' => ['municipality.title' => SORT_DESC],
        ];

        $dataProvider->sort->attributes['category.slug'] = [
            'asc' => ['category.slug' => SORT_ASC],
            'desc' => ['category.slug' => SORT_DESC],
        ];

        $dataProvider->sort->attributes['municipality.slug'] = [
            'asc' => ['municipality.slug' => SORT_ASC],
            'desc' => ['municipality.slug' => SORT_DESC],
        ];

        $query->andFilterWhere(['like', 'category.id', $this->getAttribute('category.id')]);
        $query->andFilterWhere(['like', 'category.title', $this->getAttribute('category.title')]);
        $query->andFilterWhere(['like', 'category.slug', $this->getAttribute('category.slug')]);

        $query->andFilterWhere(['like', 'municipality.id', $this->getAttribute('municipality.id')]);
        $query->andFilterWhere(['like', 'municipality.title', $this->getAttribute('municipality.title')]);
        $query->andFilterWhere(['like', 'municipality.slug', $this->getAttribute('municipality.slug')]);

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'pre_payment' => $this->pre_payment,
            'created_user_id' => $this->created_user_id,
            'updated_user_id' => $this->updated_user_id,
        ]);

        // grid filtering conditions
        $query->andFilterWhere(
            ['>=', 'status', 20]
        );

        $query->andFilterWhere(['like', 'title', $this->title])
            ->andFilterWhere(['like', 'slug', $this->slug])
            ->andFilterWhere(['like', 'phone_number', $this->phone_number])
            ->andFilterWhere(['like', 'street', $this->street])
            ->andFilterWhere(['like', 'postal_code', $this->postal_code])
            ->andFilterWhere(['like', 'municipality', $this->municipality])
            ->andFilterWhere(['like', 'province', $this->province])
            ->andFilterWhere(['like', 'email', $this->email])
            ->andFilterWhere(['like', 'web_site', $this->web_site])
            ->andFilterWhere(['like', 'facebook', $this->facebook])
            ->andFilterWhere(['like', 'instagram', $this->instagram])
            ->andFilterWhere(['like', 'whatsapp_number', $this->whatsapp_number])
            ->andFilterWhere(['like', 'booking_web_site', $this->booking_web_site])
            ->andFilterWhere(['like', 'description', $this->description])
            ->andFilterWhere(['like', 'created_at', $this->created_at])
            ->andFilterWhere(['like', 'updated_at', $this->updated_at]);

        return $dataProvider;
    }
}
