<?php

namespace bitcream\domicilio\custom\backend\controllers;

use bitcream\domicilio\custom\backend\models\Store;
use Yii;
use bitcream\domicilio\custom\backend\models\DeliveryZone;
use bitcream\domicilio\custom\backend\models\DeliveryZoneMethod;
use bitcream\domicilio\custom\backend\models\DeliveryZoneSearch;
use bitcream\domicilio\custom\backend\models\Municipality;
use bitcream\domicilio\custom\backend\models\DeliveryMethod;
use bitcream\domicilio\custom\backend\models\DeliveryMethodSearch;
use bitcream\domicilio\custom\backend\models\DeliveryZoneMethodSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use emberware\evidia\useroptions\common\models\UserOption;

/**
 * DeliveryZoneController implements the CRUD actions for DeliveryZone model.
 */
class DeliveryZoneController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['update', 'view'],
                        'allow' => true,
                        'roles' => ['ViewOwnContent'],
                        'roleParams' => function() {
                            return ['content' => DeliveryZone::findOne(['id' => Yii::$app->request->get('id')])];
                        },
                    ],
                    [
                        'actions' => ['index', 'create', 'delete-delivery-zone-method', 'save-zone-method', 'delete'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all DeliveryZone models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new DeliveryZoneSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single DeliveryZone model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new DeliveryZone model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new DeliveryZone();
        $model->store_id = UserOption::getCurrentUserOne('store_id');

        $store = Store::find()->all();
        if ($model->load(Yii::$app->request->post())) {
            $model->save();
            $model->saveMunicipality(Yii::$app->request->post()['municipality_ids']);
            return $this->redirect(['update', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
            'municipalities' => Municipality::find()->all(),
            'store' => $store,
        ]);

    }

    /**
     * Updates an existing DeliveryZone model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $store = Store::find()->all();
        $model->store_id = UserOption::getCurrentUserOne('store_id');

        $deliveryZoneMethod = DeliveryZoneMethod::find()->where(['delivery_zone_id' => $id])->one();
        if(!$deliveryZoneMethod){
            $deliveryZoneMethod = new DeliveryZoneMethod();
        }

        $deliveryMethod = new DeliveryMethod();

        $searchModel = new DeliveryZoneMethodSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        if ($model->load(Yii::$app->request->post())) {
            $model->save();
            $model->saveMunicipality(Yii::$app->request->post()['municipality_ids']);
            return $this->redirect(['index']);
        }

        return $this->render('update', [
            'model' => $model,
            'municipalities' => Municipality::find()->all(),
            'deliveryZoneMethod' => $deliveryZoneMethod,
            'deliveryMethod' => $deliveryMethod,
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'store' => $store,

        ]);
    }


    public function actionSaveZoneMethod(){

        $data = Yii::$app->request->post();

        $deliveryMethod = new DeliveryMethod();

        $deliveryMethod->cost = $data['DeliveryMethod']['cost'];
        $deliveryMethod->minimum_expense = $data['DeliveryMethod']['minimum_expense'];
        $deliveryMethod->save(false);
        $zone_id = DeliveryZoneMethod::saveZoneMethod($data, $deliveryMethod);

        return $this->redirect(['update', 'id' => $zone_id]);
    }

    public function actionDeleteDeliveryZoneMethod($id, $delivery_method_id, $delivery_zone_id){
        DeliveryZoneMethod::deleteDeliveryZoneMethod($id);

        DeliveryMethod::deleteDeliveryMethod($delivery_method_id);

        return $this->redirect(['update', 'id' => $delivery_zone_id]);
    }
    /**
     * Deletes an existing DeliveryZone model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the DeliveryZone model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return DeliveryZone the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = DeliveryZone::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('domicilio', 'The requested page does not exist.'));
    }
}
