<?php

namespace bitcream\domicilio\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%payment_method}}".
 *
 * @property int $id
 * @property string|null $title
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 *
 * @property StorePaymentMethod[] $storePaymentMethods
 */
class PaymentMethod extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%payment_method}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['status', 'created_user_id', 'updated_user_id'], 'integer'],
            [['title', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('domicilio', 'ID'),
            'title' => Yii::t('domicilio', 'Title'),
            'status' => Yii::t('domicilio', 'Status'),
            'created_at' => Yii::t('domicilio', 'Created At'),
            'created_user_id' => Yii::t('domicilio', 'Created User ID'),
            'updated_at' => Yii::t('domicilio', 'Updated At'),
            'updated_user_id' => Yii::t('domicilio', 'Updated User ID'),
        ];
    }

    /**
     * Gets query for [[StorePaymentMethods]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getStorePaymentMethods()
    {
        return $this->hasMany(StorePaymentMethod::className(), ['payment_method_id' => 'id'])->inverseOf('paymentMethod');
    }
}
