<?php

namespace bitcream\domicilio\custom\common\utils;
use Yii;
use emberware\evidia\useroptions\common\models\UserOption;
use bitcream\domicilio\custom\backend\models\Store;
/**
 * This is the class for create menu left
 */
class Menu
{

    public static function general(){

        $items = array();
        $storeId = UserOption::getCurrentUserOne('store_id');
        $currentUserId = Yii::$app->user->id;
        $currentUserRoles = Yii::$app->authManager->getRolesByUser($currentUserId);

        if (!empty($currentUserRoles["storeManager"])){
               return array_merge($items, Menu::storeManagerItems(["submenu" => false]));
        }

        if (Yii::$app->user->can('viewPlatformMenu')){
            if(true){
                $items = array_merge($items, Menu::platformAdminItems([]));
            }
        }

         //se esiste store aggiungo menu store
        if($storeId)
        {
            if(Yii::$app->user->can('viewStoreMenu')){
                if(true){
                    $items = array_merge($items, Menu::storeManagerItems(["store_id" => $storeId, "submenu" => true]));
                }
            }
        }


        if (Yii::$app->user->can('viewSysadminMenu')){
            //se l'utente è amministratore
            if(true){
                $items = array_merge($items, Menu::sysAdminItems());
            }
        }
        return $items;


    }
    public static function storeManagerItems($params){
        // $previewStandItem = array();
        $store = Store::findOne($params['store_id']);

        $subitems = [
            [
                'label' => Yii::t('domicilio', 'Anagrafica'),
                'url' => ['/custom/store/anagrafica'],
                'icon' => 'fontawesome fa fa-phone',
            ],
            [   'label' => Yii::t('domicilio', 'Delivery zone'),
                'url' => ['/custom/delivery-zone/index'],
                'icon' => 'fontawesome fa fa-bookmark',
            ],
        ];

        if($params["submenu"]){
            return   //con espositore selezionato
            [
                [   'label' =>Yii::t('domicilio', 'Store: {store}', ['store' => $store->title]),
                    'url' => '#',
                    'icon' => 'fontawesome fa fa-users',
                    'items' => $subitems
                ]
            ];
        }
        return $subitems;
    }

    public static function platformAdminItems(){
        return [
            [
                'label' => Yii::t('domicilio', 'Platform Admin'),
                'icon' => 'fontawesome fa fa-cogs',
                'url' => '#',
                'items' => [
                    [
                        'label' => Yii::t('domicilio', 'Category'),
                        'url' => ['/custom/category/index'],
                        'icon' => 'fontawesome fa fa-th',
                    ],
                    [
                        'label' => Yii::t('domicilio', 'Municipality'),
                        'url' => ['/custom/municipality/index'],
                        'icon' => 'fontawesome fa fa-shopping-cart',
                    ],
                    [
                        'label' => Yii::t('domicilio', 'Store'),
                        'url' => ['/custom/store/index'],
                        'icon' => 'fontawesome fa fa-shopping-cart',
                    ],
                    [
                        'label' => Yii::t('domicilio', 'Payment method'),
                        'url' => ['/custom/payment-method/index'],
                        'icon' => 'fontawesome fa fa-money',
                    ],
                ]
            ]
        ];
    }



    public static function sysAdminItems(){
        return [
            [
                'label' => Yii::t('domicilio', 'SysAdmin'),
                'icon' => 'fontawesome fa fa-cogs',
                'url' => '#',
                'items' => [
                    [   'label' => Yii::t('domicilio', 'Users'),
                        'url' => ['/users/user/index'],
                        'icon' => 'fontawesome fa fa-user',
                    ],
                    [
                        'label' => Yii::t('domicilio', 'Users Permissions'),
                        'url' => ['/permissions/auth-item/auth'],
                        'icon' => 'fontawesome fa fa-user'
                    ],
                    [
                        'label' => Yii::t('domicilio', 'Users Roles'),
                        'url' => ['/permissions/auth-item/rule'],
                        'icon' => 'fontawesome fa fa-user'
                    ],
                    [   'label' => Yii::t('domicilio', 'Options'),
                        'url' => ['/options/option/index'],
                        'icon' => 'fontawesome fa fa-cog'
                    ],
                ]
            ]
        ];
    }
    public static function applicationItems($params){

        return
        [
            [
                'label' => Yii::t('domicilio', 'Dashboard'),
                'url' => ['/'],
                'icon' => 'fontawesome fa fa-tachometer',
            ],
            [
                'label' => Yii::t('domicilio', 'Store'),
                'url' => ['/custom/store/index'],
                'icon' => 'fontawesome fa fa-shopping-cart',
            ],
            [
                'label' => Yii::t('domicilio', 'Category'),
                'url' => ['/custom/category/index'],
                'icon' => 'fontawesome fa fa-th',
            ],
            [
                'label' => Yii::t('domicilio', 'Municipality'),
                'url' => ['/custom/municipality/index'],
                'icon' => 'fontawesome fa fa-shopping-cart',
            ],
            [
                'label' => Yii::t('domicilio', 'DeliveryZone'),
                'url' => ['/custom/delivery-zone/index'],
                'icon' => 'fontawesome fa fa-shopping-cart',
            ],
        ];
    }

}
