<?php

namespace bitcream\domicilio\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%municipality_delivery_zone}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%delivery_zone}}`
 */
class M210511100853AddDeliveryZoneIdColumnToMunicipalityDeliveryZoneTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%municipality_delivery_zone}}', 'delivery_zone_id', $this->integer()->null());

        // creates index for column `delivery_zone_id`
        $this->createIndex(
            '{{%idx-municipality_delivery_zone-delivery_zone_id}}',
            '{{%municipality_delivery_zone}}',
            'delivery_zone_id'
        );

        // add foreign key for table `{{%delivery_zone}}`
        $this->addForeignKey(
            '{{%fk-municipality_delivery_zone-delivery_zone_id}}',
            '{{%municipality_delivery_zone}}',
            'delivery_zone_id',
            '{{%delivery_zone}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%delivery_zone}}`
        $this->dropForeignKey(
            '{{%fk-municipality_delivery_zone-delivery_zone_id}}',
            '{{%municipality_delivery_zone}}'
        );

        // drops index for column `delivery_zone_id`
        $this->dropIndex(
            '{{%idx-municipality_delivery_zone-delivery_zone_id}}',
            '{{%municipality_delivery_zone}}'
        );

        $this->dropColumn('{{%municipality_delivery_zone}}', 'delivery_zone_id');
    }
}
